package LIMS::Controller::Admin::Config::StatusOptions;

use strict;
use warnings;

use parent 'LIMS::Controller::Admin';

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

# ------------------------------------------------------------------------------
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift; # $self->stash( errs => $errs );    

	my $status_opts = $self->model('Option')->get_status_options;

	$self->tt_params( status_opts => $status_opts );
	
    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('status_options');

	return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
sub edit : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;

    my $id = $self->param('id')
    || return $self->error('no id passed to '.$self->get_current_runmode);  # $self->debug('id:'.$id);

    my $data = $self->model('Option')->get_status_option($id);

    $self->tt_params( data => $data );

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('status_options');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
sub update : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $id = $self->param('id') || '';  # $self->debug('id:'.$id);

	# put id (if submitted) into params() as _record_id for validation:	
    if ( $id ) { 
        $self->query->param( _record_id => $id );
    }

    # if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('status_options') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
    || return $self->forward('default'); # eg if empty param

	# provide 'id' if supplied, so record updated, otherwise new one created: 
	if ($id) { $data->{id} = $id; }

    my $rtn = $self->model('Option')->update_status_options($data); 

    return $rtn ?
        $self->error($rtn) :
            $self->redirect( $self->query->url . '/config/status-options' );
}

1;