package LIMS::Model::PhoneLog;

use strict;

use base 'LIMS::Model::Base';

# ------------------------------------------------------------------------------
sub get_phonelog_data {
    my ($self, $request_id) = @_;

    my %args = (
        query   => [ request_id => $request_id ],
        require_objects => 'user',
        sort_by => 'time',
    );

    my $history
        = LIMS::DB::RequestPhoneLog::Manager->get_request_phone_log(%args);

    return $history;
}

#-----------------------------------------------------------------
sub get_phonelog_options {
    my $self = shift;
    
    my $options = LIMS::DB::PhoneLogOption::Manager
        ->get_phone_log_options(sort_by => 'description');
    
    return $options;
}

#-----------------------------------------------------------------
sub get_phonelog_count {
    my ($self, $request_id) = @_;
    
    my %args = (
        query => [ request_id => $request_id ],
    );
    
    my $count
        = LIMS::DB::RequestPhoneLog::Manager->get_request_phone_log_count(%args);
    
    return $count;
}

#-----------------------------------------------------------------
sub update_phonelog {
    my $self = shift;	
    my $data = shift; # $self->debug( $data ); 
    
    my %args = ( class => 'RequestPhoneLog', data => $data );

    return $self->update_object(\%args);  	
}

1;
