#!/usr/bin/perl

use Test::WWW::Mechanize::CGIApp;

use strict;
use warnings;

use DateTime;
use POSIX;

use Test::More tests => 24;
#  use Test::More 'no_plan';

=begin # tests:

=cut

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

foreach( qw// ) {
    drop_and_recreate($_);
}

do_login();

# patient search finds 0 records:
{
    $mech->get_ok('/register/patient_search?name=noexist');   # print_and_exit(); 
    has_flash_message('info');                                # print_and_exit();
    $mech->get('/');                                          # print_and_exit();
    lacks_flash_message('info');                              # print_and_exit();    
}

# new clinician:
{
    $mech->get_ok('/config/clinicians');                     # print_and_exit(); 
    
    my %new = (
        prefix => 'C',
        national_code => 1234567,
        surname => 'brown',
        initials_1 => 'a',
        initials_2 => 'b',
        referral_source_id => 1,
        hospital_department_code => 823,
    );
    
    #error:
    $mech->submit_form(fields => \%new);                       # print_and_exit();
    has_flash_message('warning');                              # print_and_exit();
    $mech->get('/');                                           # print_and_exit();
    lacks_flash_message('warning');                            # print_and_exit();    

    #error: # TODO - flash working but error message maybe wrong
    $new{surname} = 'green'; # unique but duplicate national code
    $mech->get('/config/clinicians');
    $mech->submit_form(fields => \%new);                       # print_and_exit();
    has_flash_message('warning');                              # print_and_exit();
    $mech->get('/');                                           # print_and_exit();
    lacks_flash_message('warning');                            # print_and_exit();    
    
    # success:
    $mech->get('/config/clinicians');                          # print_and_exit(); 
    $new{national_code} = 2345678; # unique
    $mech->submit_form(fields => \%new);                       # print_and_exit();
    has_flash_message('info');                                 # print_and_exit();
    $mech->get('/');                                           # print_and_exit();
    lacks_flash_message('info');                               # print_and_exit();  
}

# edit clinician:
{
    $mech->get('/config/clinicians/edit/1');                   # print_and_exit(); 
    $mech->field(active => 'no');
    $mech->submit_form();
    has_flash_message('info');                                 # print_and_exit();
    $mech->get('/');                                           # print_and_exit();
    lacks_flash_message('info');                               # print_and_exit();  
}

# change password - mismatch:
{
    $mech->get_ok('/user/change_password');                   # print_and_exit(); 
    $mech->field(old_password => 'incorrect');
    $mech->field(new_password => 'changed');
    $mech->field(new_password_confirm => 'changed');
    $mech->submit_form();                                     # print_and_exit();
    
    has_flash_message('error');                                # print_and_exit();
    $mech->get('/');                                           # print_and_exit();
    lacks_flash_message('error');                              # print_and_exit();    
}

# change password - success
#### WILL GET LOGGED OUT HERE ####
{
    $mech->get_ok('/user/change_password');                   # print_and_exit();
    
    $mech->field(old_password => 'adm1n');
    $mech->field(new_password => 'changed');
    $mech->field(new_password_confirm => 'changed');
    $mech->submit_form();                                      # print_and_exit();
    
    has_flash_message('info');                                 # print_and_exit();
    $mech->get('/');                                           # print_and_exit();
    lacks_flash_message('info');                               # print_and_exit();    
}

#### now logged out

# test lost password flash message after logout:
{
    $mech->form_name('forgotten_pwd');
    $mech->field(email_address => 'nosuch@example.com');
    $mech->submit();                                        # print_and_exit();
    
    $mech->content_contains(
        get_messages('login')->{email_not_found},
        'OK: flash message present',
    );
    $mech->get('/');                                         # print_and_exit();
    $mech->content_lacks(
        get_messages('login')->{email_not_found},
        'OK: flash message absent',
    );
}

sub has_flash_message {
    my $class = shift;
    
    my $prefix = uc $class;
    
    $mech->content_like(
        qr/p class="$class">\s+$prefix/,
        'OK: flash message present',
    );
}

sub lacks_flash_message {
    my $class = shift;
    
    my $prefix = uc $class;
    
    $mech->content_unlike(
        qr/p class="$class">\s+$prefix/,
        'OK: flash message absent',
    );
}



