package LIMS::DB::RequestHistory;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'request_history',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        request_id => { type => 'integer', not_null => 1 },
        action     => { type => 'varchar', length => 255, not_null => 1 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },

        user => {
            class       => 'LIMS::DB::User',
            key_columns => { user_id => 'id' },
        },
    ],
);
#=cut

#__PACKAGE__->meta->table('request_trial');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 4);

__PACKAGE__->meta->make_manager_class('request_histories');

1;
