#!/usr/bin/perl

use Test::WWW::Mechanize::CGIApp;
use Test::Builder::Tester;

use Data::Dumper;

use strict;
use warnings;

use constant TESTS => 18;

use Test::More tests => TESTS;
# use Test::More 'no_plan';

=begin: tests:
=cut

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

do_login();

my $dbh;
eval {
    $dbh = get_dbh() or die 'no database handle received from get_dbh';
};

my $dbix = get_dbix();

{ # manually request test with associated linked lab-test:
    # 3 new lab tests:
    $dbix->insert('lab_tests', {
        field_label => 'Test-1', lab_section_id => 1, test_type => 'test',
        has_results => 'no', is_active => 'yes', test_name => 'test_1',
    });
    my $new = get_last_insert_id('lab_tests');
    _do_lab_test_sample_type($new);
    
    $dbix->insert('lab_tests', {
        field_label => 'Linked-1', lab_section_id => 1, test_type => 'test',
        has_results => 'no', is_active => 'yes', test_name => 'linked_1',
    });
    _do_linked_lab_test($new);
    
    $dbix->insert('lab_tests', {
        field_label => 'Linked-2', lab_section_id => 1, test_type => 'test',
        has_results => 'no', is_active => 'yes', test_name => 'linked_2',
    });
    _do_linked_lab_test($new);
}

# screen request #1:
$mech->get_ok('/screen/do_initial_screen/1?screen_id=2;option_id=1'); # print_and_exit();
{
    $mech->has_tag_like(
        dt => qr(requested lab-tests),
        'OK: screen success',
    );                                                        # print_and_exit();
	# check have requested test:
    $mech->has_tag_like(
        span => qr(PNH),
        'OK: new requested test'
    );														  # print_and_exit();
    $mech->has_tag_like(
        span => qr(\[pending\]),
        'OK: new requested test'
    );														  # print_and_exit();
    
    # does not have linked tests:
    for ('Linked-1','Linked-2') {
        test_out( 'not ok 1 - foo' );
        test_fail( +1 );
        $mech->has_tag_like( span => qr($_), 'foo' );
        test_test( "OK: no pending $_ lab-test" );            # print_and_exit();
    }
}

# manually request Test-1 which auto-links Linked-1 & Linked-2:
$mech->get_ok('/result/=/1');                                  # print_and_exit();
{
    $mech->form_name('flow_requests');
    $mech->tick('test_id', 10, 1);
    $mech->submit();                                          # print_and_exit();

	# check have requested test:
    for ('Test-1', 'Linked-1', 'Linked-2') {
        $mech->has_tag_like(
            span => qr($_),
            "OK: new requested test $_"
        );													 # print_and_exit();
    }
}
$mech->get_ok('/history/=/1');                               # print_and_exit();
{
    my $i = 1;
    $mech->has_tag_like(
        td => qr(requested Test-1),
        "OK: expected history found [$i]"
    );													     # print_and_exit();
    $i++; 
    for ('Linked-1', 'Linked-2') {
        $mech->has_tag_like(
            td => qr(requested linked test $_),
            "OK: expected history found [$i]"
        );													 # print_and_exit();
        $i++;
    }
}
sub _do_linked_lab_test {
    my $id = shift;
    my $new = get_last_insert_id('lab_tests');
    $dbix->insert( 'linked_lab_test',
        { lab_test_id => $id, linked_test_id => $new });
    _do_lab_test_sample_type($new);
}

sub _do_lab_test_sample_type {
    my $id = shift;
    $dbix->insert( 'lab_test_sample_type',
        { lab_test_id => $id, sample_type_id => 1 });    
}