#!/usr/bin/perl

=begin -------------------------------------------------------------------------
alerts Southampton CTU of newly registered REMoDL-B trial cases:
=cut ---------------------------------------------------------------------------

use strict;
use warnings;

my $JUST_TESTING = 1; # email to ra.jones only

############ recipients from contacts.lib ######################################
my @recipients = qw( raj.secure sharon.barrans.secure southampton.ctu.secure);
################################################################################

BEGIN {
    use FindBin qw($Bin); # warn $Bin;
    use lib (
        "$Bin/../../../lib",
        '/home/raj/perl5/lib/perl5',
    );
}

use LIMS::Local::ScriptHelpers;
use LIMS::Model::Email;
use Data::Dumper;

my $tools = LIMS::Local::ScriptHelpers->new();

# get tools from LIMS::Local::ScriptHelpers:
my $contacts = $tools->get_contacts();
my $sql_lib  = $tools->sql_lib();
my $config   = $tools->config();
my $dbix     = $tools->dbix();

# get date yesterday - handles BST:
my $yesterday = $tools->date_subtract(days => 1)->dmy('/'); # warn $yesterday; exit;

# get sql statment:
my $requests = $sql_lib->retr('new_remodlb_cases_alert');
# email subject line:
my $subject = "REMoDL-B cases registered at HMDS on $yesterday";
# email message body row format:
my $row_format = "%-8s %-12s %-12s %-12s %-11s %-10s %s\n";


my $cases = $dbix->query($requests)->arrays; # AoA

if (@$cases) {
    my $message_body = sprintf $row_format,
        qw( LabNo LastName FirstName DoB UnitNumber NHSNumber Source );
    $message_body .= sprintf $row_format, @$_ for @$cases;
    
	my %mail = (		
		config  => $config,
		message => $message_body,
		subject => $subject, 	
	); # warn Dumper \%mail; exit;
    
	RECIPIENT:
	foreach my $recipient (@recipients) { 
		my $email = $contacts->{$recipient} or next RECIPIENT; # in case doesn't exist
        next RECIPIENT if ( $JUST_TESTING && $email !~ /ra\.jones/ );
        
		$mail{recipient} = $email; # warn Dumper $mail{recipient};
        
		my $rtn = LIMS::Model::Email->send_message(\%mail);
		warn "Error in $0: $rtn" if $rtn;
	}
}


