CREATE TABLE `lab_test_accreditation` (
	`lab_test_id` SMALLINT(6) NOT NULL,
	`accreditation_date` DATE NULL DEFAULT NULL,
	PRIMARY KEY (`lab_test_id`),
	CONSTRAINT `lab_test_accreditation_ibfk_1` FOREIGN KEY (`lab_test_id`) REFERENCES `lab_tests` (`id`)
) ENGINE=InnoDB;

insert into lab_test_accreditation(lab_test_id,accreditation_date)
	select id, '2017-03-28' from lab_tests lt where lt.is_active = 'yes' order by lt.id;
	
update lab_test_accreditation t1 set t1.accreditation_date = NULL where lab_test_id in (
	13, # stem_cell (Flow)
	47, # plasma_cell (Flow)
	247,# cebp_alpha (Molecular)
	293,# fgfr3 (FISH)
	353,# ezh2 (HTS)
	396,# dusp22_irf4 (FISH)
	397,# tp63_6p25 (FISH) 
	399,# pml_rar_alpha (FISH) # check also Molecular
	408,# mlpa_myeloma (MLPA)
	447,# lmo2 (Immunohistochemistry)
	449,# hts_cll_mzl (HTS)
	479,# mlpa_cll (MLPA)
	529,# 11q23 (FISH)
	530,# 11q24 (FISH)
	531 # 11q panel (FISH)
);
	