#!/usr/bin/perl

# plack script - "plackup --port 8080 $0" - almost works - need to comment out
# error_document in LIMS::Dispatch %local_args (use MiddleWare::ErrorDocument)
# LIMS::_check_portal_referral() failing to find exemptions (? ENV params)

use FindBin qw($Bin); # warn 'BIN:'.$Bin;
# set lib paths for app:
use lib "$Bin/../lib";

use CGI::Application::Dispatch::PSGI;
use LIMS::Dispatch;
use Plack::Builder;
use Data::Dumper;

my $args = LIMS::Dispatch->dispatch_args; # warn Dumper $args;

my $app = CGI::Application::Dispatch::PSGI->as_psgi(%$args);

builder {
    enable sub {
        my $app = shift;
        sub {
            my $env = shift;
            $env->{ROSEDB_DEVINIT} = "$Bin/../config/rosedb_devinit_devel.pl"; # overrides default db test
            # switch LIMS::RDBO $Rose::DB::Object::Debug on:
            $env->{RDBO_DEBUG} = 1;
            # flag for QueryLog:
            $env->{DEVEL_SERVER} = 1;
            # set REPORT_HTML flag - server operates in single-process mode so calling img in url
            # for PDF generation fails:
            $env->{REPORT_HTML} = 1; # warn 'env:'; warn Dumper $env;
            return $app->($env); # need to return response
        }
    };
    enable "StackTrace";
    enable "Debug";
    enable "Static",
        path => qr!^/(css|images|js|docs|files)/!,
        root => "$Bin/../static";
    mount '/hmds' => $app;
};

