package LIMS::DB::UserGroupFunction;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'user_group_function',

    columns => [
        group_id     => { type => 'integer', not_null => 1 },
        function_id  => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ qw(group_id function_id) ],

    foreign_keys => [
        function => {
          class       => 'LIMS::DB::UserFunction',
          key_columns => { function_id => 'id' },
        },
        group => {
          class       => 'LIMS::DB::UserGroup',
          key_columns => { group_id => 'id' },
        },
    ],
);

# or to see what it should be:
#__PACKAGE__->meta->table('trials');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 2, braces => 'bsd');

__PACKAGE__->meta->make_manager_class('user_group_functions');

1;
