package LIMS::DB::RequestViewLog;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'request_view_log',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        request_id  => { type => 'integer', not_null => 1 },
        user_id     => { type => 'integer', not_null => 1 },
        ip_address  => { type => 'varchar', length => 15, not_null => 1 },
        time        => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
    
    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
        },
        user => {
            class       => 'LIMS::DB::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

#=cut

__PACKAGE__->meta->make_manager_class('request_view_logs');

1;
