package LIMS::DB::PreRegistration;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'pre_registration',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        labno       => { type => 'varchar', length => 8, not_null => 1 },
        surname     => { type => 'varchar', length => 25 },
        is_screened => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'no', not_null => 1 },
        time        => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'labno' ],
    
    relationships => [
        pre_registration_specimen => {
            class      => 'LIMS::DB::PreRegistrationSpecimen',
            column_map => { id => 'pre_reg_id' },
            type       => 'one to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('pre_registration');

1;