package LIMS::DB::GenomicsFamilyId;

# exists to map Genomics family_id result to requests using genomics_family_id_view

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table => 'family_id_view',

    columns => [
        request_id => { type => 'integer' }, # read-only view so only need  minimal defs
        family_id  => { type => 'varchar' },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

1;
