#!/usr/bin/perl

use Test::WWW::Mechanize::CGIApp;
use Test::Builder::Tester;

use Data::Dumper;

use strict;
use warnings;

use Test::More tests => 25; 

=begin: tests:
1) add new foreign id
2) amend foreign id
3) delete foreign id
=cut

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

do_login();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

my $foreign_id = 'Z123';

# get results page:
$mech->get_ok('/result/=/1');                                 
{
    $mech->form_name('flow_results');
    
    $mech->field( foreign_id => $foreign_id );
    $mech->submit();                                          # print_and_exit();
    
    lacks_dfv_errors();                                       # print_and_exit();
    $mech->content_contains( 
        get_messages('action')->{edit_success},
        'OK: new record succeeded',
    );                                                        # print_and_exit();     
}

# check history:
$mech->get_ok('/history/=/1');                                # print_and_exit();  
{
    $mech->has_tag(
        td => 'new Flow remote system ID',
        'OK: expected history present',
    );
}

# relaod for edit:
$mech->get_ok('/result/=/1');
{    
    $mech->content_contains(
        $foreign_id, 'OK: expected foreign id detected'
    );                                                        # print_and_exit(); 

    $foreign_id .= 4; # add a digit
    
    $mech->form_name('flow_results');   
    $mech->field( foreign_id => $foreign_id );
    $mech->submit();                                          # print_and_exit(); 

    lacks_dfv_errors();                                       # print_and_exit();
    $mech->content_contains( 
        get_messages('action')->{edit_success},
        'OK: new record succeeded',
    );                                                        # print_and_exit();    
}

# check history:
$mech->get_ok('/history/=/1');                                # print_and_exit();  
{
    $mech->has_tag(
        td => 'updated Flow remote system ID',
        'OK: expected history present',
    );
}

# reload for deletion:
$mech->get_ok('/result/=/1');
{
    $mech->content_contains(
        $foreign_id, 'OK: expected foreign id amended'
    );                                                        # print_and_exit();

    $mech->form_name('flow_results');   
    $mech->field( foreign_id => undef );
    $mech->submit();                                          # print_and_exit();

    lacks_dfv_errors();                                       # print_and_exit();
    $mech->content_contains( 
        get_messages('action')->{edit_success},
        'OK: new record succeeded',
    );                                                        # print_and_exit();    
}

# check history:
$mech->get_ok('/history/=/1');                                # print_and_exit();  
{
    $mech->has_tag(
        td => 'deleted Flow remote system ID',
        'OK: expected history present',
    );
}

$mech->get_ok('/result/=/1');
{
    $mech->content_lacks(
        $foreign_id, 'OK: expected foreign id deleted'
    );  
}

do_logout();

