#!/usr/bin/perl

use Test::WWW::Mechanize::CGIApp;
# use HTML::TreeBuilder;
use Data::Dumper;

use strict;
use warnings;

use Test::More tests => 81; # use Test::More 'no_plan';

=begin: tests:
1) add new parent_organisations - test all required fields
2) edit new parent_organisations - parent_code & description
3) add new hospital source - test all required fields
4) submit complete data
5) edit new hospital display_name
6) edit new hospital org_code to unique value
7) submit new hospital - duplicate org_code
8) correct org_code to unique & resubmit
9) add new practice - test all required fields
10) submit complete data

=cut

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

do_login();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

# need to drop & re-create following tables:
foreach ( qw/referral_sources parent_organisations/ ) {
    drop_and_recreate($_);
}

# new parent_organisation for hospital:
$mech->get_ok('/config/parent-organisations');          # print_and_exit(); 
{
    my %new_organisation = (
        parent_code      => 'ABC',
        description      => 'NEWTON NHS TRUST',
        referral_type    => 'hospital', 
    );
    
    # test each required field:
    test_missing_required(\%new_organisation);
    
    # submit complete form:
    $mech->form_name('parent-organisations');
    $mech->submit_form(fields => \%new_organisation);       # print_and_exit();

    # no errors:
    lacks_dfv_errors();

    # check record create success:
    $mech->content_contains(
        get_messages('action')->{create_success},
        'OK: new record created',
    );                                                      # print_and_exit();
    
   ### check source found:
    retrieve_all_records('parent_organisation_search','description');  # print_and_exit();
    foreach (keys %new_organisation) {
        $mech->content_contains(
            qq!value="$new_organisation{$_}"!,
            'OK: new source value detected',
        );                                       
    }                                                   # print_and_exit();
}

# new parent_organisation for practice:
$mech->get_ok('/config/parent-organisations');          # print_and_exit(); 
{
     my %new_organisation = (
        parent_code      => 'B12344',
        description      => 'OLD SURGERY, NT1 1TN',
        referral_type    => 'practice', 
    );
   
    $mech->submit_form(fields => \%new_organisation);           # print_and_exit();
    
    lacks_dfv_errors();
    
    $mech->content_contains(
        get_messages('action')->{create_success},
        'OK: new record created',
    );                                                       # print_and_exit();
    ### check source found:
    retrieve_all_records('parent_organisation_search','description');  # print_and_exit();
    foreach (keys %new_organisation) {
        $mech->content_contains(
            qq!value="$new_organisation{$_}"!,
            'OK: new source value detected',
        );                                       
    }                                                    # print_and_exit();
}

# edit new practice parent_organisation:
$mech->get_ok('/config/parent-organisations/edit/2');         # print_and_exit(); 
{
    my $new_value = 'B12345';
    
    $mech->field(parent_code => $new_value);
    $mech->submit_form();                                # print_and_exit();
    
    lacks_dfv_errors();
    
    # edit success detected:
    $mech->content_contains(
        get_messages('action')->{edit_success},
        'OK: new value detected'
    );

    retrieve_all_records('parent_organisation_search','description');  # print_and_exit();

    # new value is detected:
    $mech->content_contains(
        $new_value,
        'OK: new value detected'
    );
    # old value not detected:
    $mech->content_lacks(
        'B12344',
        'OK: old value not detected'
    );                                                  # print_and_exit();
}

# edit new hospital parent_organisation:
$mech->get_ok('/config/parent-organisations/edit/1');         # print_and_exit(); 

{
    my $new_value = 'NEWTOWN NHS TRUST';
    
    $mech->field(description => $new_value);
    $mech->submit_form();                               # print_and_exit();
    
    lacks_dfv_errors();
    
    # edit success detected:
    $mech->content_contains(
        get_messages('action')->{edit_success},
        'OK: new value detected'
    );

    retrieve_all_records('parent_organisation_search','description');  # print_and_exit();

    # new value is detected:
    $mech->content_contains(
        $new_value,
        'OK: new value detected'
    );
    # old value not detected:
    $mech->content_lacks(
        'NEWTON NHS TRUST',
        'OK: old value not detected'
    );                                                  # print_and_exit();
}

SKIP: {
    skip('TODO: test creation of duplicate parent_code & description fields',1);    
}

$mech->get_ok('/config/referral-sources');         # print_and_exit(); 

### check title:
$mech->content_contains(
    'Admin &raquo; Referral Sources',
    'title matches',
);                                     # print_and_exit();

# add new hospital source:
{
    my %new_hospital = (
        referral_type     => 'hospital', 
        organisation_code => 'ABC01',
        display_name      => 'Newtown General Infirmary',
        parent_organisation_id => 1,
    );
    
    # test each required field:
    test_missing_required(\%new_hospital);
    
    # submit complete form:
    $mech->form_name('referral_source');
    $mech->submit_form(fields => \%new_hospital);             #print_and_exit();

    # no errors:
    lacks_dfv_errors();

    # check record create success:
    $mech->content_contains(
        get_messages('action')->{create_success},
        'OK: new record created',
    );                                                      # print_and_exit();

    ### check source found:
    retrieve_all_records('find_referral_source','display_name'); # print_and_exit();
    foreach (qw/organisation_code display_name/) {
        $mech->content_contains(
            qq!value="$new_hospital{$_}"!,
            'OK: new source value detected',
        );                                       
    }                                                   # print_and_exit();
}

# edit new hospital display_name:
$mech->get_ok('/config/referral-sources/edit/1');         # print_and_exit(); 
{
    $mech->content_contains(
         'Edit Referral Source Details',
        'OK: edit page loaded',
    );                                              # print_and_exit();

    # trivial name change:
    my $new = 'Newtown Northern';
    $mech->field('display_name' => $new);
    $mech->submit_form;                          # print_and_exit();
    
    # check no dfv error:
    lacks_dfv_errors();
    
    # edit success detected:
    $mech->content_contains(
        get_messages('action')->{edit_success},
        'OK: new value detected'
    );
    
    retrieve_all_records('find_referral_source','display_name'); # print_and_exit();
    $mech->content_contains(
         $new,
        'OK: new display name detected',
    );                                          # print_and_exit();
    $mech->content_lacks(
         'Newtown General Infirmary',
        'OK: old value not detected',
    );                                          # print_and_exit();

}

# edit new hospital org_code:
$mech->get_ok('/config/referral-sources/edit/1');         # print_and_exit(); 
{
    my $new = 'ABC02';
    $mech->field('organisation_code' => $new);
    $mech->submit_form();                                  #  print_and_exit(); 
    
    # no errors:
    lacks_dfv_errors();

    # edit success detected:
    $mech->content_contains(
        get_messages('action')->{edit_success},
        'OK: new value detected'
    );

    retrieve_all_records('find_referral_source','display_name'); # print_and_exit();
    $mech->content_contains(
         $new,
        'OK: new organisation_code name detected',
    );                                          # print_and_exit();
    $mech->content_lacks(
         'ABC01',
        'OK: old value not detected',
    );                                          # print_and_exit();

}

# duplicate org_code:
$mech->get_ok('/config/referral-sources');         # print_and_exit(); 
{
    my $new_source_name = 'Newtown General Infirmary';
    
    my %source = (
        organisation_code => 'ABC02', # duplicate
        display_name      => $new_source_name,
        referral_type     => 'hospital',
        parent_organisation_id => 1,
    );
    
    $mech->submit_form(fields => \%source);                 # print_and_exit();    
    
    # check we have dfv error:
    has_dfv_errors();

    # correct org_code to unique:
    $mech->field(organisation_code => 'ABC03');
    $mech->submit_form();                              # print_and_exit();
    
    lacks_dfv_errors();
    # check record create success:
    $mech->content_contains(
        get_messages('action')->{create_success},
        'OK: new record created',
    );                                                      # print_and_exit();
    
    # retrieve all records:
    retrieve_all_records('find_referral_source','display_name'); # print_and_exit();
    # check both hospitals detected:
    foreach ( $new_source_name, 'Newtown Northern' ) {
        $mech->content_contains(
            $_,
            'OK: location name detected',
        );                                                  
    }                                                    # print_and_exit();
}

# add new practice:
{ 
    $mech->get_ok('/config/referral-sources');         # print_and_exit();
    
    my %new_practice = (
        referral_type     => 'practice', 
        organisation_code => 'B54321',
        practice_name     => 'New Surgery',
        practice_address  => 'New Road, Newtown',
        practice_zip      => 'NT1 1TN',
    );
    
    # test each required field:
    test_missing_required(\%new_practice);
    
    # submit complete form:
    $mech->submit_form(fields => \%new_practice);                # print_and_exit();
    
    # check we not not have dfv error:
    lacks_dfv_errors();

    # check record create success:
    $mech->content_contains(
        get_messages('action')->{create_success},
        'OK: new record created',
    );                                                      # print_and_exit();
    
    # retrieve all records:
    retrieve_all_records('find_referral_source','display_name'); # print_and_exit();

    ### check practice details found:
    foreach (qw/organisation_code practice_name practice_address practice_zip/) {
        $mech->content_contains(
            $new_practice{$_},
            'OK: new source value detected',
        );                                       
    }                                                  # print_content();
}

# do_logout(); logout link not available for admin function

