package LIMS::Model::LabSection;

use strict;

use base 'LIMS::Model::Base';

#-------------------------------------------------------------------------------
sub get_lab_section {
    my $self = shift;
    my $id   = shift;

    my $section = LIMS::DB::LabSection->new(id => $id)->load; # DEBUG $test;

    return $section;
}

#-------------------------------------------------------------------------------
sub get_lab_section_by_name {
    my $self = shift;
    my $name = shift;

    my $section = LIMS::DB::LabSection->new(section_name => $name)->load; # DEBUG $test;

    return $section;
}

#-------------------------------------------------------------------------------
sub get_lab_sections {
    my $self   = shift;
    my $params = shift || {};

    $params->{sort_by} ||= 'section_name';

    # get lab_section rows as arrayref:
    my $data = LIMS::DB::LabSection::Manager->get_lab_sections(%$params); # $self->debug($data);

    return $data;
}

#-------------------------------------------------------------------------------
sub get_section_status_options {
    my ($self, $lab_section_id) = @_; 
    
    my %args = (
        query => [ lab_section_id => $lab_section_id ],
        require_objects => 'status_option',
    );
    
    my $status_options = LIMS::DB::LabSectionStatusOption::Manager
        ->get_lab_section_status_option(%args);
        
    return $status_options;
}

#-------------------------------------------------------------------------------
sub get_labsection_remote_system_ids {
    my ($self, $request_id) = @_; # DEBUG $section; return;

    my %args = (
        query => [ request_id => $request_id ],
        require_objects => 'lab_section',
    );

    my $remote_system_ids = LIMS::DB::RequestLabSectionForeignID::Manager
        ->get_request_lab_section_foreign_ids(%args);

    return $remote_system_ids;
}

#-------------------------------------------------------------------------------
sub update_section_status_options {
    my $self = shift;
    my $data = shift; # DEBUG $section; return;

    my $db = $self->lims_db; # ie LIMS::DB->new_or_cached;
    
    my $status_option_id = $data->{option_id};
    
    my $update = sub {
        # first clear existing data:
        LIMS::DB::LabSectionStatusOption::Manager->delete_lab_section_status_option(
#            db    => $db,
            where => [ lab_section_id => $data->{section_id} ],
        );      
        
        if ( ref $status_option_id eq 'ARRAY' ) {
            for (@$status_option_id) {
                LIMS::DB::LabSectionStatusOption->new(
#                    db => $db,
                    status_option_id => $_,
                    lab_section_id   => $data->{section_id},
                )->save;
            }
        }
        elsif ($status_option_id) { # need to test in case it's a submit to clear
            LIMS::DB::LabSectionStatusOption->new(
#                db => $db,
                status_option_id => $status_option_id,
                lab_section_id   => $data->{section_id},
            )->save;
        }
    };
    
    my $ok = $db->do_transaction($update);

    # don't need return value unless error:
    return $ok ? 0 : 'update_lab_section_status_options() error - ' . $db->error;    
}

#-------------------------------------------------------------------------------
sub update_lab_sections {
    my $self = shift;
    my $data = shift; # DEBUG $section; return;

    my %args = ( class => 'LabSection', data  => $data );

    return $self->update_object(\%args);
}

#-------------------------------------------------------------------------------
sub get_section_result_summaries {
    my ($self, $request_id) = @_; # DEBUG $section; return;

    my %args = (
        query => [ request_id => $request_id ],
        require_objects => 'lab_section',
    );

    my $result_summaries = LIMS::DB::RequestResultSummary::Manager
        ->get_request_result_summaries(%args);

    return $result_summaries;
}



1;