package LIMS::Model::Audit;

use Moose;
with 'LIMS::Model::Roles::DBIxSimple'; # get_sql_with_constraint()
extends 'LIMS::Model::Base';
use namespace::clean -except => 'meta';
__PACKAGE__->meta->make_immutable;

use Data::Dumper;
use LIMS::Local::Utils;

#-------------------------------------------------------------------------------
sub turnaround_times {
    my $self = shift;
    my $vars = shift || {}; # will be empty on 1st call
    
    $self->params($vars);
    
	my $dbix = $self->lims_dbix;

    my $sql_lib_entry = $self->_get_sql_lib_entry_for_selection($vars->{selection});
    my @attr = ($sql_lib_entry, 'time'); # sub-select in use so don't need alias
    my $sql = $self->get_sql_with_constraint(@attr); # warn $sql;

    my $query = $dbix->query( $sql ); # warn Dumper $query;
    
    # for calculation of delta workings days:
    my $delta_business_days = sub { LIMS::Local::Utils::delta_business_days(@_) };
    
    my %data; # controller needs array for sorting, but easier to create hashref for 'count'
    while ( my $vars = $query->hash ) {
        my $specimen = $vars->{sample_code}; # warn $specimen;
        my $screened = $vars->{description};
        
        # need to split PB's according to request:
        if ($specimen eq 'PB') {
            $specimen = 'PB [PNH]' if $screened eq 'PNH';
            $specimen = 'PB [HIV]' if $screened eq 'HIV';
            $specimen = 'PB [CMP]' if $screened eq 'Community monitoring';
            $specimen = 'PB [Mol]' if $screened =~ /^(CMPD|Chimerism|Molec|CML follow-up)/;
        }
        
        $data{$specimen}{count}++; # increment specimen count
        
        # get registered, reported & authorised dates; using DATE_FORMAT in sql
        # MUCH faster than dt conversion afterwards:
        my ($registered, $reported, $authorised)
            = @{$vars}{ qw(registered reported authorised) };

        # calculate registered => reported & registered => auth'ed durations:
        my $delta = &$delta_business_days($registered, $reported);
        $data{$specimen}{delta_report} += $delta;
        
        if ($authorised) { # if using authorisation stage
            my $delta = &$delta_business_days($registered, $authorised);
            $data{$specimen}{delta_authorise} += $delta;
        }
    } # warn Dumper \%data;
    
    my $title = $self->constraint_title; # set in Role _set_search_constraints()
    
    return (\%data, $title); # return array format
}

#-------------------------------------------------------------------------------
sub nhs_number_supplied {
    my $self = shift;
    my $vars = shift || {}; # will be empty on 1st call
    
    $self->params($vars);
    
	my $dbix = $self->lims_dbix;

    my @attr = ('nhs_number_compliance', 'r.created_at');
    my $sql = $self->get_sql_with_constraint(@attr); # warn $sql;

    my $data  = $dbix->query( $sql )->hashes; # warn Dumper $data;
    my $title = $self->constraint_title; # set in Role _get_search_constraints()

    return ($data, $title); # return array format
}

#-------------------------------------------------------------------------------
sub revised_diagnoses {
    my $self = shift;
    my $vars = shift || {}; # will be empty on 1st call
    
    $self->params($vars);
    
	my $dbix = $self->lims_dbix;

    my %data;
    { # get revised diagnoses over duration:        
        my @attrs = ('revised_diagnoses', 'dh.time', 'one_month'); # default to 1 month
        my $sql = $self->get_sql_with_constraint(@attrs); # warn $sql;    
        my $revisions = $dbix->query($sql)->hashes; # warn Dumper $data;
        $data{revisions} = $revisions;
    }
    { # get total reported over duration:
        my $constraint = $self->constraint; # set in Role
        $constraint =~ s/\w+\.(\w+)/$1/; # remove alias - only have 1 table to search
        my $sql = qq!select count(*) from request_history where $constraint
            and action = 'reported'!; # warn $sql;
        my $total = $dbix->query($sql)->list;
        $data{total} = $total;
    }
    
    my $title = $self->constraint_title; # set in Role _get_search_constraints()

    return (\%data, $title); # return array format
}

#-------------------------------------------------------------------------------
sub _get_sql_lib_entry_for_selection { # remove this if not selecting by specimen, location, etc
    my ($self, $selection) = @_;
    
    my %t = (
        specimen => 'turnaround_times_specimen',
    );

    my $lib_entry_name = $t{$selection};
    
    # have to modify lib_entry_name if authorisation stage not in use:
    if (! $self->does_authorisation) {
        $lib_entry_name .= '_no_authorisation';
    }
    return $lib_entry_name;
}

1;
