package LIMS::Local::Debug;

use strict;
use warnings;

use Exporter;
use FileHandle;
use Data::Dumper;
use LIMS::Local::Config;

use vars qw( $fh @EXPORT );

@EXPORT = qw( DEBUG debug_path );

sub import { goto &Exporter::import }

sub DEBUG {
    # don't want t/*.t output unless specifically requested:
    return if ($ENV{HARNESS_ACTIVE} && ! $ENV{DEBUG_ON});

	my $cfg = LIMS::Local::Config->instance;
    my $path_to_app_root = $cfg->{path_to_app_root}; # warn Dumper $path_to_app_root;

    unless ($fh) {
        $fh = new FileHandle '>' . "$path_to_app_root/logs/debug.txt" or die $!;
    }

    warn Dumper @_; # send to stdout

    print $fh join '', map {
		ref $_ ? Dumper $_ : $_ . "\n";
	} grep $_, @_;

    $fh->flush; # for mod_perl
}

=begin # using LIMS::Local::Config->instance now
# can't use LIMS::Utils version as LT use's this package
sub find_home { # warn Dumper \@INC;
    my $path_to_app;

    foreach (@INC) {
        if (-e "$_/script/lims_server.pl") { # warn 'PATH:', $_;
            $path_to_app = $_ and last;
        }
    }

    return $path_to_app;
}
=cut

1;