package LIMS::Controller::Roles::FormData;

use Moose::Role;

use Data::FormValidator;
use LIMS::Local::Config;

use Data::Dumper;

sub get_data_from_dfv {
    my $self = shift;
    my $profile = shift
        || return $self->error('no profile passed to get_data_from_dfv()');
    
	my $validator = $self->_get_validator(); # warn Dumper $validator;

    my $dfv = $validator->check($self->query, $profile);
    my $data = $dfv->valid(); # $self->debug($data);
    
    return $data;
}

sub validate_form_params {
    my $self = shift;
    my $profile = shift
        || return $self->error('no profile passed to get_data_from_dfv()');

	my $validator = $self->_get_validator(); # warn Dumper $validator;
	
    my $results = $validator->check($self->query, $profile);    
    return $results;
}

# loads dfv_defaults from LIMS config:
sub _get_validator {
	my $self = shift;
	
	my $cfg = LIMS::Local::Config->instance;
	
	my $dfv = Data::FormValidator->new({}, $cfg->{dfv_defaults});
	return $dfv;
}

1;
