#
#===============================================================================
#
#  DESCRIPTION: Interface to send RFCs to Issues board
#  uses plugins
#  implemented Trello plugin via LIMS::Local::IssueTracker::Plugin::Trello
#  future plugin ideas: GitLab?
#
#===============================================================================
package LIMS::Local::IssueTracker;

use Modern::Perl;
use utf8;
use FindBin qw($RealBin);    # warn $RealBin;
use lib $RealBin . '../lib';
use LIMS::Local::Config;
use LIMS::Local::Utils;
use LIMS::Local::ScriptHelpers;
use Data::Printer;
use Data::Dumper;

use Moose;
use namespace::autoclean;

has 'config_file' => (
    is      => 'ro',
    isa     => 'Str',
    default => 'issue_tracking',
);

has 'config' => (
    is      => 'ro',
    isa     => 'HashRef',
    builder => '_build_config',
    lazy    => '1'
);

with 'MooseX::Object::Pluggable';

sub _build_config {
    my ($self) = @_;
    my $yaml;
    if ( $ENV{HARNESS_ACTIVE} ) { # warn 'here';
        # dont hammer the live Trello board while testing
        $yaml = YAML::Tiny->read( $self->config_file )->[0];
        $yaml->{board} = $yaml->{board}->{test};
    }
    else { # warn 'here';
        my $config = LIMS::Local::Config->instance;
        my $tools  = LIMS::Local::ScriptHelpers->new;
        my ($top_level_hilis) = $RealBin =~ /^(.*apps\/HILIS4)/;
        $tools->use_path($top_level_hilis);
        $yaml = $tools->get_yaml_file( $self->config_file );
        $yaml->{board} = $yaml->{board}->{live};
    }
    return $yaml;
}

#sub load_configured_plugin{
sub BUILD {
    my $self = shift;
    $self->load_plugin( $self->config->{plugin} );  # config needs to load first
    $self->check_config()
      or die $self->config->{plugin} . " config error: " . $!;
}

__PACKAGE__->meta->make_immutable;

1;
