package LIMS::DB::Outreach::RequestNotification;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',

    table   => 'request_notification',

    columns => [
        request_id   => { type => 'integer', not_null => 1 },
        event_id     => { type => 'integer', not_null => 1 },
        time         => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'event_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
        },
        event => {
            class       => 'LIMS::DB::Outreach::NotificationEvent',
            key_columns => { event_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('request_notifications');

1;