package LIMS::DB::Outreach::RequestFollowup;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',

    table   => 'request_followup',

    columns => [
        request_id           => { type => 'integer', not_null => 1 },
        followup_option_id   => { type => 'integer', not_null => 1 },
        time                 => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        followup_option => {
            class        => 'LIMS::DB::Outreach::FollowupOption',
            key_columns  => { followup_option_id => 'id' },
        },
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
        },
    ],
    
    relationships => [
        clinic_return => {
            class      => 'LIMS::DB::Outreach::RequestClinicReturn',
            column_map => { request_id => 'request_id' },
            type       => 'one to one',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('request_followups');

1;