package LIMS::Controller::Local::Worklist::FishWorksheetCustom;

use base 'LIMS::Base';

use Moose;
with(
    'LIMS::Controller::Roles::Misc',    'LIMS::Controller::Roles::User',
    'LIMS::Controller::Roles::DataMap', 'LIMS::Local::Role::Worklist',
);

has 'tt_name' => ( is => 'rw', isa => 'Str' );
__PACKAGE__->meta->make_immutable( inline_constructor => 0 );

use Data::Dumper;
use File::Basename qw(basename);
use URI::Escape qw( uri_unescape);

# ------------------------------------------------------------------------------
sub default : StartRunmode {
    my $self = shift;
    # get CGI parameters
    my @request_ids = grep { /^\d+$/ } $self->query->param('request_id');
    my $template = uri_unescape( $self->query->param('template') );
    if ( not @request_ids or not $template ) {
        my $url = $self->query->url()
          . '/local_worklist?function_name=fish_worksheets_custom';
        return $self->redirect($url);
    }

    # check only allowed characters in template filename and template found
    my @template_names =
      map { basename $_ } $self->get_fish_custom_template_names;
    if ( $template =~ m{([\w ./-]+)}
        and grep { $template eq $_ } @template_names )
    {
        $self->tt_params( fish_template => $template );
    }
    else {
        die "invalid template parameter: $template";    # valid template file
    }

    # get request & report data for request_ids:
    my %args = (    # to use existing method used by Search function
        search_constraints => { id => \@request_ids },
    );              # warn Dumper \%args;
    my $requests = $self->model('Request')->find_requests( \%args );
    $self->tt_params( requests => $requests );    # warn Dumper $requests;

    #    { # specimen map:
    #		my $specimen_map = $self->specimen_map(\@request_ids);
    #		$self->tt_params( specimen_map => $specimen_map );
    #    }
    {    # request_options:
        my $map = $self->request_options_map( \@request_ids );
        $self->tt_params( request_options_map => $map );
    }

#    { # get flow section result summary:
#        my @args = (\@request_ids, 'Flow cytometry'); # method accepts list mode args
#        my $o = $self->model('LabSection')->get_section_result_summaries(@args);
#        # convert to hashref map for tt:
#        my %map = map { $_->request_id => $_->results_summary } @$o;
#        $self->tt_params( result_summaries => \%map ); # warn Dumper \%map;
#    }
    {    # get lab-test data from FISH section:
        my %args = (
            section_name => 'FISH',
            request_id   => \@request_ids,
        );
        my $request_lab_tests =
          $self->model('LabTest')->get_request_lab_tests_for_section( \%args );

        # convert to hashref map for tt:
        my %map =
          ();    # need hash of arrays of objects - 1 request to many tests:
        push @{ $map{ $_->request_id } }, $_->as_tree for @$request_lab_tests;
        $self->tt_params( fish_data => \%map );    # warn Dumper $fish_tests;

        # get probesets for fish panels:
        my $probes = $self->_get_fish_panel_probes_as_test_names();    # warn Dumper $probes;
        $self->tt_params( panel_probes => $probes );

        # prepare data here before sending to template
        # [{rid => [ probes, ],}
        my $template_data = {};
        foreach (@$request_lab_tests) {
            my @tests;
            if ( $_->lab_test->test_type eq 'panel' ) {

                # push panel tests onto @test
                if ( exists $probes->{ $_->lab_test->test_name } )
                {    # not all probes have tests
                    push @tests, @{ $probes->{ $_->lab_test->test_name } };
                }
            }
            else {
                push @tests, $_->lab_test->test_name;
            }

            # build template_data->{rid}->[]
            push @{ $template_data->{ $_->request_id } }, @tests;
        }
$DB::single=1;
        $self->tt_params( template_data => $template_data );
    }

    return $self->render_view(
        "worklist/local/fish/custom_templates_wrapper.tt");
}

1;
