#!/usr/bin/perl -w

use strict;
use warnings;

use lib '.';

use DBI;
use DBIx::Simple;
use Anonymise::HILIS3;
use FindBin qw($RealBin); # warn $RealBin; exit;

my $dbname = $ARGV[0] || die 'require new db name';

my @login = qw( raj adm1n );

my $dbh = DBI->connect(
	"DBI:mysql:database=$dbname;host=localhost", @login, { RaiseError => 1 }
);

my $dbix = DBIx::Simple->new($dbh);
$dbix->lc_columns = 0;

# Anonymise::HILIS3::anonymise_patient() needs hashref of PID rows:
my $patient = $dbix->query("select * from $dbname.PID");

# get all existing nhs_numbers so we don't attempt to duplicate one still unprocessed:
my $sql = "select NHSNo from $dbname.PID where NHSNo is not null";
my $all_nhs_numbers = $dbix->query( $sql )->flat;
		
my $anonymiser = Anonymise::HILIS3->new(
	path_to_app => "$RealBin/../..", 
	existing_nhs_numbers => $all_nhs_numbers,
);

while ( my $vals = $patient->hash ) {
    $anonymiser->anonymise_patient($vals);

    my $p_id = $vals->{P_ID}; # warn $p_id;
    delete $vals->{P_ID};
    $dbix->update("$dbname.PID", $vals, { P_ID => $p_id } );
}

