package LIMS::Controller::Roles::Barcode;

use HTML::Barcode::DataMatrix;
use HTML::Barcode::Code128;
use HTML::Barcode::Code93;
use HTML::Barcode::QRCode;

use Moose::Role;

sub barcode_code128 {
    my ($self, $text, %args) = @_;
	my $img = HTML::Barcode::Code128->new( %args, text => $text );
	return $img->render_barcode; # excludes css
}

sub barcode_code93 {
    my ($self, $text, %args) = @_;
	my $img = HTML::Barcode::Code93->new( %args, text => $text );
	return $img->render_barcode; # excludes css
}

sub barcode_qrcode {
    my ($self, $text, %args) = @_;

	my $img = HTML::Barcode::QRCode->new( %args, text => $text );
	return $img->render_barcode; # excludes css
}

sub barcode_data_matrix {
    my ($self, $text, %args) = @_;

	my $img = HTML::Barcode::DataMatrix->new( %args, text => $text );
	return $img->render_barcode; # excludes css
}

1;
