package LIMS::DB::AuthorisedReport;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table => 'authorised_reports_view',

    columns => [ # read-only view so don't need NULL/NOT NULL
        id                => { type => 'integer' },
        request_number    => { type => 'integer' },
        year              => { type => 'integer' },
        reg_date          => { type => 'date'    },
        last_name         => { type => 'varchar' },
        first_name        => { type => 'varchar' },
        dob               => { type => 'date'    },
        unit_number       => { type => 'varchar' },
        age               => { type => 'integer' },
        nhs_number        => { type => 'varchar' },
        location          => { type => 'varchar' },
        organisation_code => { type => 'varchar' },
        parent_code       => { type => 'varchar' },
        diagnosis         => { type => 'varchar' },
        icdo3             => { type => 'varchar' },
        status            => { type => 'varchar' },
        auth_date         => { type => 'date'    },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { id => 'id' },
            rel_type    => 'one to one',
        },
    ],
    relationships => [
        request_specimen => {
            class      => 'LIMS::DB::RequestSpecimen',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('authorised_reports');

1;
