package LIMS::DB::Outreach::QuestionnaireAdenopathy;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    schema  => 'outreach',
    
    table   => 'questionnaire_adenopathy',
    
    columns => [
        request_id => { type => 'integer', not_null => 1 },
        cervical_swelling  => { type => 'enum', check_in => [ 'Y', 'N' ] },
        axillary_swelling  => { type => 'enum', check_in => [ 'Y', 'N' ] },
        abdominal_swelling => { type => 'enum', check_in => [ 'Y', 'N' ] },
        inguinal_swelling  => { type => 'enum', check_in => [ 'Y', 'N' ] },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);
#=cut

__PACKAGE__->meta->make_manager_class('questionnaire_adenopathy');

1;
