#!/usr/bin/env perl

# Dancer2 fileuploader - requires D2 0.166 with symkat fixes in ~/perl-lib
BEGIN { 
	$ENV{DANCER_APPHANDLER} = 'PSGI';
	$ENV{DANCER_ENVIRONMENT} = $ENV{PLACK_ENV} = 'production';
}

# for development debugging:
BEGIN { 
	use lib (
		'/home/raj/perl-lib/Dancer2-0.166-fix/lib/perl5',
		'/home/raj/perl5/lib/perl5',
		'/home/raj/apps/FileUploader/lib',
	);
	use autodie; 
	close STDERR; 
	open STDERR, '>>', '/home/raj/apps/FileUploader/logs/debug.txt'; # doesn't record 'die' events
}

use Dancer2;
use Plack::Runner;

# For some reason Apache SetEnv directives dont propagate
# correctly to the dispatchers, so forcing PSGI and env here
# is safer.
set apphandler => 'PSGI';
set environment => 'production'; # doesn't work - set in BEGIN block above

my $psgi = '/home/raj/apps/FileUploader/bin/app.psgi';
die "Unable to read startup script: $psgi" unless -r $psgi;

Plack::Runner->run($psgi);
