package LIMS::DB::Outreach::NotificationEvent;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',

    table   => 'notification_events',

    columns => [
        id   => { type => 'integer', not_null => 1 },
        days => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'days' ],

    relationships => [
        request_notification => {
            class      => 'LIMS::DB::Outreach::RequestNotification',
            column_map => { id => 'event_id' },
            type       => 'one to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('notification_events');

1;