SELECT @section_id := id FROM lab_sections WHERE section_name = 'High-throughput sequencing';

INSERT INTO lab_tests( test_name, field_label, lab_section_id, test_type, has_results, is_active ) VALUES
	(LOWER('ARID1A'), 'ARID1A', @section_id, 'test', 'yes', 'yes'),
	(LOWER('ATM'), 'ATM', @section_id, 'test', 'yes', 'yes'),
	(LOWER('BRAF'), 'BRAF', @section_id, 'test', 'yes', 'yes'),
	(LOWER('BIRC3'), 'BIRC3', @section_id, 'test', 'yes', 'yes'),
	(LOWER('BTK'), 'BTK', @section_id, 'test', 'yes', 'yes'),
	(LOWER('CARD11'), 'CARD11', @section_id, 'test', 'yes', 'yes'),
	(LOWER('CCND1'), 'CCND1', @section_id, 'test', 'yes', 'yes'),
	(LOWER('CD79B'), 'CD79B', @section_id, 'test', 'yes', 'yes'),
	(LOWER('CDKN1B'), 'CDKN1B', @section_id, 'test', 'yes', 'yes'),
	(LOWER('CREBBP'), 'CREBBP', @section_id, 'test', 'yes', 'yes'),
	(LOWER('CXCR4'), 'CXCR4', @section_id, 'test', 'yes', 'yes'),
	(LOWER('EGR2F'), 'EGR2_F', @section_id, 'test', 'yes', 'yes'),
	(LOWER('EP300'), 'EP300', @section_id, 'test', 'yes', 'yes'),
	(LOWER('FBXW7'), 'FBXW7', @section_id, 'test', 'yes', 'yes'),
	(LOWER('KLF2'), 'KLF2', @section_id, 'test', 'yes', 'yes'),
	(LOWER('MAP2K1'), 'MAP2K1', @section_id, 'test', 'yes', 'yes'),
	(LOWER('MED12'), 'MED12', @section_id, 'test', 'yes', 'yes'),
	(LOWER('MYD88'), 'MYD88', @section_id, 'test', 'yes', 'yes'),
	(LOWER('NFKBIE'), 'NFKBIE', @section_id, 'test', 'yes', 'yes'),
	(LOWER('NOTCH1'), 'NOTCH1', @section_id, 'test', 'yes', 'yes'),
	(LOWER('NOTCH2'), 'NOTCH2', @section_id, 'test', 'yes', 'yes'),
	(LOWER('PLCG2'), 'PLCG2', @section_id, 'test', 'yes', 'yes'),
	(LOWER('POT1'), 'POT1', @section_id, 'test', 'yes', 'yes'),
	(LOWER('RPS15'), 'RPS15', @section_id, 'test', 'yes', 'yes'),
#	(LOWER('SF3B1'), 'SF3B1', @section_id, 'test', 'yes', 'yes'), # already exists
	(LOWER('TLR2'), 'TLR2', @section_id, 'test', 'yes', 'yes'),
	(LOWER('TNFAIP3'), 'TNFAIP3', @section_id, 'test', 'yes', 'yes'),
#	(LOWER('TP53'), 'TP53', @section_id, 'test', 'yes', 'yes'),   # already exists
	(LOWER('TRAF2'), 'TRAF2', @section_id, 'test', 'yes', 'yes'),
	(LOWER('TRAF3'), 'TRAF3', @section_id, 'test', 'yes', 'yes'),
	(LOWER('UBR5'), 'UBR5', @section_id, 'test', 'yes', 'yes'),
	(LOWER('WHSC1'), 'WHSC1', @section_id, 'test', 'yes', 'yes'),
	(LOWER('XPO1'), 'XPO1', @section_id, 'test', 'yes', 'yes');

SELECT @section_id := id FROM lab_sections WHERE section_name = 'High-throughput sequencing';

CREATE TEMPORARY TABLE temp(id INT);
INSERT INTO temp
	SELECT id FROM lab_tests WHERE test_name IN (
		'arid1a',
		'atm',
		'braf',
		'birc3',
		'btk',
		'card11',
		'ccnd1',
		'cd79b',
		'cdkn1b',
		'crebbp',
		'cxcr4',
		'egr2f',
		'ep300',
		'fbxw7',
		'klf2',
		'map2k1',
		'med12',
		'myd88',
		'nfkbie',
		'notch1',
		'notch2',
		'plcg2',
		'pot1',
		'rps15',
#		'sf3b1',
		'tlr2',
		'tnfaip3',
#		'tp53',
		'traf2',
		'traf3',
		'ubr5',
		'whsc1',
		'xpo1'
) AND lab_section_id = @section_id;	

INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id)  
	SELECT id, 1 FROM temp;
INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id)  
	SELECT id, 2 FROM temp;
INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id)  
	SELECT id, 3 FROM temp;

SELECT @type_id := id FROM lab_test_result_data_types WHERE description = 'ngs_text';
INSERT INTO lab_test_data_type(lab_test_id, data_type_id, is_active) 
	SELECT id, @type_id, 'yes' FROM temp;
	

