package Role::RebuildTables;

use Moose::Role;
use Data::Dumper;

sub rebuild_tables {
    my $self  = shift;
    my $table = shift; # scalar or arrayref

	if ( ref $table eq 'ARRAY' ) {
		$self->rebuild($_) foreach @$table;
	}
	else {
		$self->rebuild($table);
	}
}

# not required anymore - fixed SuSE performance issue now
sub rebuild_tables_asMyISAM {
	my $self = shift;
	my $tbl  = shift; # warn $tbl;

    $self->rebuild($tbl);

=begin    
    my $dbh = $self->db->{dbh4};

    $dbh->do( qq!DROP TABLE IF EXISTS `$tbl`! );
    
    my $sql = $self->sql->{table}->{$tbl};
    $sql =~ s/InnoDB/MyISAM/; 
	$dbh->do( $sql );
=cut
}

# not required anymore - fixed SuSE performance issue now
sub convert_to_InnoDB {
	my $self = shift;
	my $tbl  = shift; # warn $tbl;    
=begin
    my $dbh = $self->db->{dbh4};

    $dbh->do( qq!ALTER TABLE $tbl ENGINE="InnoDB"! );
=cut
}

sub rebuild {
	my $self = shift;
	my $tbl  = shift; # warn $tbl;

    my $dbh = $self->db->{dbh4};

    $dbh->do( qq!DROP TABLE IF EXISTS `$tbl`! ); 
	$dbh->do( $self->sql->{table}->{$tbl} );
}

sub clear_table {
	my ($self, $table) = @_;

    my $dbh = $self->db->{dbh4};

	$dbh->do( qq!TRUNCATE TABLE $table!);
    # $dbh->do( qq!ALTER TABLE $table ENGINE="MyISAM"! ); # fixed SuSE performance issue now
}

1;
