package LIMS::DB::UserPermission;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'user_permission',

    columns => [
        user_id     => { type => 'integer', not_null => 1 },
        function_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ qw(user_id function_id) ],

    foreign_keys => [
        function => {
            class       => 'LIMS::DB::UserFunction',
            key_columns => { function_id => 'id' },
        },

        user => {
            class       => 'LIMS::DB::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

# or to see what it should be:
#__PACKAGE__->meta->table('trials');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 2, braces => 'bsd');

__PACKAGE__->meta->make_manager_class('user_permissions');

1;


