#!/usr/bin/perl

use strict;
use warnings;

use lib '/home/raj/perl5/lib/perl5';

use DBI;
use Config::Tiny;
use Data::Dumper;
use CGI::Session::ExpireSessions;

use constant DAYS => 1;

# print 'Removing sessions that are more than '.DAYS." days old:\n";

my $path_to_app_root = '/home/raj/www/apps/HMDS/trunk';
#    || die "Couldn't find path to application directory"; # warn $path_to_app_root;

my $config = Config::Tiny->read("$path_to_app_root/config/settings.txt"); # $self->debug($config);
my %settings = %{ $config->{global} }; # warn Dumper \%settings; exit;

my %args = (
    delta   => DAYS * 24 * 60 * 60,  # seconds
#    delta   => 2, # use for testing -- expire sessions that haven't been accessed in 2 seconds
    verbose => 1,
    cgi_session_dsn => { # match method in CGI_SESSION_OPTIONS
        db   => "driver:mysql;serializer:$settings{db_session_serializer}",
        file => "driver:File;serializer:$settings{file_session_serializer}",
    },
    dsn_args => {
        db => {
            DataSource  => "dbi:mysql:database=$settings{development_db}",
            User        => $settings{db_user_id},
            Password    => $settings{db_password},
        },
        file => {
            Directory => $path_to_app_root.'/sessions',
#           NoFlock   => '',
#           Umask     => '',
        }
    },
);

# database sessions table:
CGI::Session::ExpireSessions->new(
    delta           => $args{delta},
    verbose         => $args{verbose},
    dsn_args        => $args{dsn_args}->{db},
    cgi_session_dsn => $args{cgi_session_dsn}->{db},
)->expire_sessions;

# sessions directory:
CGI::Session::ExpireSessions->new(
    delta           => $args{delta},
    verbose         => $args{verbose},
    dsn_args        => $args{dsn_args}->{file},
    cgi_session_dsn => $args{cgi_session_dsn}->{file},
)->expire_sessions;
