package LIMS::Model::Test;

use strict;

use base 'LIMS::Model::Base';
use Data::Dumper;

#-------------------------------------------------------------------------------
sub get_all_diagnoses {
    my $self = shift;

    my %args = (
        sort_by => 'name',
        require_objects => 'diagnostic_category',
        limit => 5,
    );

    my $data = LIMS::DB::Diagnosis::Manager->get_diagnosiss(%args); # DEBUG $data;

    return $data;
}

# experimental method using DBIx::Simple - too slow with CONCAT in sql
sub get_request_and_patient_data_from_labno {
    my ($self, $labnos) = @_; # warn Dumper $labnos;
    
    my $dbix = $self->lims_dbix;
    
    my $sql = q!
        select r.id, p.last_name from requests r join patient_case pc on
        r.patient_case_id = pc.id join patients p on pc.patient_id = p.id
        where concat('H', r.request_number, '/', r.year - 2000) in (??)!;
        
    my $data = $dbix->query( $sql, @$labnos)->hashes; # warn Dumper $data;
    
    return $data;
}

1;
