package DB;

use lib qw(
    /home/raj/perl5/lib/perl5
);

use DBIx::Simple;

use Moose;
use namespace::clean -except => 'meta';

has config => (
	is       => 'ro',
	isa      => 'Config::Tiny',
    required => 1,
);

=begin # expects config file to supply:
src_host=<hilis3 host address>
src_db=<hilis3 db name>
src_username=<hilis3 db username>
src_passwd=<hilis3 db passwd>

hilis4_host=<hilis4 host address> # probably localhost
hilis4_db=<hilis4 db name>
hilis4_username=<hilis4 db username>
hilis4_passwd=<hilis4 db passwd>
=cut

sub connect {
	my $self = shift;

    my $cfg = $self->config->{_}; # '_' = root section

	my $local_db    = $cfg->{hilis4_db};
    my $local_host  = $cfg->{hilis4_host};
    my @local_login = map $cfg->{$_}, qw(hilis4_username hilis4_passwd);

    my $hilis3_db    = $cfg->{src_db};
    my $hilis3_host  = $cfg->{src_host};
    my @hilis3_login = map $cfg->{$_}, qw(src_username src_passwd);

    # DBI->trace(3, './trace.log');

    my $dbh3 = DBI->connect(
		"DBI:mysql:database=$hilis3_db;host=$hilis3_host",
		@hilis3_login, { RaiseError => 1 }
	);
    my $dbh4 = DBI->connect(
		"DBI:mysql:database=$local_db;host=$local_host",
		@local_login, { RaiseError => 1 }
	);

    my $dbix3 = DBIx::Simple->new($dbh3);
    my $dbix4 = DBIx::Simple->new($dbh4);

    return {
        dbh3  => $dbh3,
        dbh4  => $dbh4,
        dbix3 => $dbix3,
        dbix4 => $dbix4,
    }
}

sub disconnect {
	my $self = shift;
	my $db   = shift;
	
	$db->{dbh3}->disconnect();
	$db->{dbh4}->disconnect();	
}

1;
