package LIMS::Controller::Admin::Config::ResultDataTypes;

use base 'LIMS::Base';
use LIMS::Local::Sugar;

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

# -------------------------------------------------------------------------------------
startmode default ($errs) {
    $self->_debug_path($self->get_current_runmode);

    # get list of lab_test_result_data_types:
    my $data_types = $self->model('Base')->get_objects('LabTestResultDataType');
    
    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('result_data_types');

    $self->tt_params( data_types => $data_types );
    return $self->tt_process;
}

#-------------------------------------------------------------------------------
sub edit : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;

    my $id = $self->param('id') || return $self->error('no id passed to '.$self->get_current_runmode); # $self->debug('id:'.$id);

    my $data = $self->model('Result')->get_result_data_type($id);

    $self->tt_params( data => $data );

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('result_data_types');

    return $self->tt_process($errs);
}

#-------------------------------------------------------------------------------
sub update : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

	my $id = $self->param('id');
	
	# put id (if submitted) into params() as _record_id for validation:	
    if ( $id ) { 
        $self->query->param( _record_id => $id );
    }

    # if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('result_data_types') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
	|| return $self->forward('default'); # eg if empty param

	# provide 'id' if supplied, so record updated, otherwise new one created: 
	if ($id) { $data->{id} = $id; }

    my $rtn = $self->model('Result')->update_result_data_type($data);

	if ($rtn) {
		return $self->error($rtn);
	}
	else {
		# set success msg:
		my $msg = $id ? 'edit_success' : 'create_success';
		$self->flash( info => $self->messages('action')->{$msg} );
		return $self->redirect( $self->query->url . '/config/result-data-types' ); # safer to redirect after db edit
	}
}
1;