-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               5.5.58-0+deb7u1 - (Debian)
-- Server OS:                    debian-linux-gnu
-- HeidiSQL Version:             9.4.0.5170
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Dumping structure for table hmrn_test.antecedent_events
CREATE TABLE IF NOT EXISTS `antecedent_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.antecedent_events: ~23 rows (approximately)
/*!40000 ALTER TABLE `antecedent_events` DISABLE KEYS */;
INSERT INTO `antecedent_events` (`id`, `event`) VALUES
	(1, 'Haematological malignancy'),
	(2, 'Non-haematological malignancy'),
	(3, 'Down\'s syndrome'),
	(4, 'Sjogren\'s syndrome'),
	(5, 'Hashimoto\'s thyroiditis'),
	(6, 'Organ transplantation'),
	(7, 'Helicobacter pylori'),
	(8, 'Immunodeficiency'),
	(9, 'Coeliac disease'),
	(10, 'Monoclonal gammopathy'),
	(11, 'Monoclonal B lymphocytosis'),
	(12, 'Haem & non-haem malignancies'),
	(13, 'Rheumatoid arthritis'),
	(14, 'Unknown'),
	(15, 'None'),
	(16, 'Other (see comments)'),
	(17, 'Aplastic anaemia'),
	(18, 'SLE'),
	(19, 'Haemolytic anaemia'),
	(20, 'Benign haematology'),
	(21, 'Auto-immune disorder'),
	(22, 'Polymyaligia rheumatica'),
	(23, 'Kidney disease');
/*!40000 ALTER TABLE `antecedent_events` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.categories
CREATE TABLE IF NOT EXISTS `categories` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `category` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.categories: ~4 rows (approximately)
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` (`id`, `category`) VALUES
	(1, 'precursor'),
	(2, 'myeloid'),
	(3, 'lymphoid'),
	(4, 'plasmacell');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.category_parameter
CREATE TABLE IF NOT EXISTS `category_parameter` (
  `category_id` smallint(6) NOT NULL DEFAULT '0',
  `parameter_id` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`category_id`,`parameter_id`),
  KEY `parameter_id` (`parameter_id`),
  CONSTRAINT `category_parameter_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`),
  CONSTRAINT `category_parameter_ibfk_2` FOREIGN KEY (`parameter_id`) REFERENCES `parameters` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.category_parameter: ~71 rows (approximately)
/*!40000 ALTER TABLE `category_parameter` DISABLE KEYS */;
INSERT INTO `category_parameter` (`category_id`, `parameter_id`) VALUES
	(4, 2),
	(3, 3),
	(4, 3),
	(3, 4),
	(4, 4),
	(4, 5),
	(1, 6),
	(2, 6),
	(3, 6),
	(4, 6),
	(3, 7),
	(4, 7),
	(4, 8),
	(3, 9),
	(4, 9),
	(4, 11),
	(4, 12),
	(4, 13),
	(4, 14),
	(4, 15),
	(1, 16),
	(2, 16),
	(3, 16),
	(4, 16),
	(3, 17),
	(1, 18),
	(2, 18),
	(3, 18),
	(4, 18),
	(1, 19),
	(2, 19),
	(3, 19),
	(4, 19),
	(3, 20),
	(4, 20),
	(3, 21),
	(3, 22),
	(3, 23),
	(3, 24),
	(3, 25),
	(3, 26),
	(3, 27),
	(1, 28),
	(2, 28),
	(3, 28),
	(4, 28),
	(2, 29),
	(2, 30),
	(2, 31),
	(2, 32),
	(2, 33),
	(2, 35),
	(2, 36),
	(2, 37),
	(2, 38),
	(4, 39),
	(1, 40),
	(2, 40),
	(3, 40),
	(4, 40),
	(1, 41),
	(2, 41),
	(3, 41),
	(4, 41),
	(2, 42),
	(4, 45),
	(1, 46),
	(2, 46),
	(3, 46),
	(4, 46),
	(4, 47);
/*!40000 ALTER TABLE `category_parameter` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.defaults_and_ranges
CREATE TABLE IF NOT EXISTS `defaults_and_ranges` (
  `param_id` int(11) NOT NULL DEFAULT '0',
  `min_value` decimal(2,1) NOT NULL DEFAULT '0.0',
  `max_value` decimal(10,1) NOT NULL DEFAULT '0.0',
  `not_stated` decimal(10,1) NOT NULL DEFAULT '0.0',
  `not_done` decimal(10,1) NOT NULL DEFAULT '0.0',
  PRIMARY KEY (`param_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table hmrn_test.defaults_and_ranges: ~17 rows (approximately)
/*!40000 ALTER TABLE `defaults_and_ranges` DISABLE KEYS */;
INSERT INTO `defaults_and_ranges` (`param_id`, `min_value`, `max_value`, `not_stated`, `not_done`) VALUES
	(4, 0.0, 800.0, 888.0, 999.0),
	(6, 1.0, 25.0, 88.8, 99.9),
	(7, 0.0, 80.0, 88.0, 99.0),
	(8, 9.0, 2200.0, 8888.0, 9999.0),
	(14, 0.0, 80000.0, 88888.0, 99999.0),
	(15, 0.0, 80000.0, 88888.0, 99999.0),
	(18, 0.1, 8000.0, 8888.0, 9999.0),
	(19, 0.1, 8000.0, 8888.0, 9999.0),
	(20, 1.0, 70.0, 888.0, 999.0),
	(28, 1.0, 8000.0, 8888.0, 9999.0),
	(37, 0.0, 100.0, 888.0, 999.0),
	(39, 0.0, 80.0, 88.8, 99.9),
	(40, 0.0, 800.0, 888.0, 999.0),
	(41, 0.0, 800.0, 888.0, 999.0),
	(42, 0.0, 70.0, 88.8, 99.9),
	(46, 0.0, 100.0, 888.0, 999.0),
	(47, 0.0, 100.0, 888.0, 999.0);
/*!40000 ALTER TABLE `defaults_and_ranges` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.events
CREATE TABLE IF NOT EXISTS `events` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.events: ~4 rows (approximately)
/*!40000 ALTER TABLE `events` DISABLE KEYS */;
INSERT INTO `events` (`id`, `description`) VALUES
	(1, 'diagnosis'),
	(2, 'first_appointment'),
	(3, 'palliative_care'),
	(4, 'deceased');
/*!40000 ALTER TABLE `events` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.history
CREATE TABLE IF NOT EXISTS `history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `user_id` smallint(6) NOT NULL DEFAULT '0',
  `action` varchar(255) NOT NULL DEFAULT '',
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=340 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.history: ~255 rows (approximately)
/*!40000 ALTER TABLE `history` DISABLE KEYS */;
INSERT INTO `history` (`id`, `patient_id`, `user_id`, `action`, `time`) VALUES
	(1, 2, 1, 'added new precursor data set', '2017-10-13 13:38:02'),
	(2, 2, 1, 'added new precursor data set', '2017-10-13 14:07:44'),
	(3, 2, 1, 'added new precursor data set', '2017-10-13 14:24:02'),
	(4, 2, 1, 'added new detection_liver value', '2017-10-13 14:24:03'),
	(5, 2, 1, 'added new splenomegaly value', '2017-10-13 14:24:03'),
	(6, 2, 1, 'added new epo value', '2017-10-13 14:24:03'),
	(7, 2, 1, 'added new pcv value', '2017-10-13 14:24:03'),
	(8, 2, 1, 'added new detection_spleen value', '2017-10-13 14:24:03'),
	(9, 2, 1, 'added new hepatomegaly value', '2017-10-13 14:24:03'),
	(10, 2, 1, 'updated haematocrit_vol value [60 -> 70]', '2017-10-13 14:29:17'),
	(11, 2, 1, 'added new precursor data set', '2017-10-13 14:34:19'),
	(12, 2, 1, 'added new detection_liver value', '2017-10-13 14:34:19'),
	(13, 2, 1, 'added new splenomegaly value', '2017-10-13 14:34:19'),
	(14, 2, 1, 'added new epo value', '2017-10-13 14:34:19'),
	(15, 2, 1, 'added new pcv value', '2017-10-13 14:34:19'),
	(16, 2, 1, 'added new detection_spleen value', '2017-10-13 14:34:19'),
	(17, 2, 1, 'added new hepatomegaly value', '2017-10-13 14:34:19'),
	(18, 2, 1, 'added new precursor data set', '2017-10-13 14:35:34'),
	(19, 2, 1, 'added new detection_liver value', '2017-10-13 14:35:34'),
	(20, 2, 1, 'added new splenomegaly value', '2017-10-13 14:35:34'),
	(21, 2, 1, 'added new epo value', '2017-10-13 14:35:34'),
	(22, 2, 1, 'added new pcv value', '2017-10-13 14:35:34'),
	(23, 2, 1, 'added new detection_spleen value', '2017-10-13 14:35:34'),
	(24, 2, 1, 'added new hepatomegaly value', '2017-10-13 14:35:34'),
	(25, 2, 1, 'added new precursor data set', '2017-10-13 14:38:52'),
	(26, 2, 1, 'added new detection_liver value', '2017-10-13 14:38:53'),
	(27, 2, 1, 'added new splenomegaly value', '2017-10-13 14:38:53'),
	(28, 2, 1, 'added new epo value', '2017-10-13 14:38:53'),
	(29, 2, 1, 'added new pcv value', '2017-10-13 14:38:53'),
	(30, 2, 1, 'added new detection_spleen value', '2017-10-13 14:38:53'),
	(31, 2, 1, 'added new hepatomegaly value', '2017-10-13 14:38:53'),
	(32, 2, 1, 'added new precursor data set', '2017-10-13 14:40:00'),
	(33, 2, 1, 'added new detection_liver value', '2017-10-13 14:40:00'),
	(34, 2, 1, 'added new splenomegaly value', '2017-10-13 14:40:00'),
	(35, 2, 1, 'added new epo value', '2017-10-13 14:40:00'),
	(36, 2, 1, 'added new pcv value', '2017-10-13 14:40:00'),
	(37, 2, 1, 'added new detection_spleen value', '2017-10-13 14:40:00'),
	(38, 2, 1, 'added new hepatomegaly value', '2017-10-13 14:40:00'),
	(39, 2, 1, 'added new precursor data set', '2017-10-13 14:42:48'),
	(40, 2, 1, 'added new detection_liver value', '2017-10-13 14:42:48'),
	(41, 2, 1, 'added new splenomegaly value', '2017-10-13 14:42:48'),
	(42, 2, 1, 'added new epo value', '2017-10-13 14:42:48'),
	(43, 2, 1, 'added new pcv value', '2017-10-13 14:42:48'),
	(44, 2, 1, 'added new detection_spleen value', '2017-10-13 14:42:48'),
	(45, 2, 1, 'added new hepatomegaly value', '2017-10-13 14:42:48'),
	(46, 2, 1, 'added new precursor data set', '2017-10-13 14:43:20'),
	(47, 2, 1, 'added new detection_liver value', '2017-10-13 14:43:20'),
	(48, 2, 1, 'added new splenomegaly value', '2017-10-13 14:43:20'),
	(49, 2, 1, 'added new epo value', '2017-10-13 14:43:20'),
	(50, 2, 1, 'added new pcv value', '2017-10-13 14:43:20'),
	(51, 2, 1, 'added new detection_spleen value', '2017-10-13 14:43:20'),
	(52, 2, 1, 'added new hepatomegaly value', '2017-10-13 14:43:20'),
	(53, 2, 1, 'added new precursor data set', '2017-10-13 14:45:45'),
	(54, 2, 1, 'added new detection_liver value', '2017-10-13 14:45:46'),
	(55, 2, 1, 'added new splenomegaly value', '2017-10-13 14:45:46'),
	(56, 2, 1, 'added new epo value', '2017-10-13 14:45:46'),
	(57, 2, 1, 'added new pcv value', '2017-10-13 14:45:46'),
	(58, 2, 1, 'added new detection_spleen value', '2017-10-13 14:45:46'),
	(59, 2, 1, 'added new hepatomegaly value', '2017-10-13 14:45:46'),
	(60, 2, 1, 'added new precursor data set', '2017-10-13 15:01:12'),
	(61, 2, 1, 'added new detection_liver value', '2017-10-13 15:01:12'),
	(62, 2, 1, 'added new splenomegaly value', '2017-10-13 15:01:12'),
	(63, 2, 1, 'added new epo value', '2017-10-13 15:01:12'),
	(64, 2, 1, 'added new pcv value', '2017-10-13 15:01:12'),
	(65, 2, 1, 'added new detection_spleen value', '2017-10-13 15:01:12'),
	(66, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:01:12'),
	(67, 2, 1, 'added new precursor data set', '2017-10-13 15:01:54'),
	(68, 2, 1, 'added new detection_liver value', '2017-10-13 15:01:54'),
	(69, 2, 1, 'added new splenomegaly value', '2017-10-13 15:01:54'),
	(70, 2, 1, 'added new epo value', '2017-10-13 15:01:54'),
	(71, 2, 1, 'added new pcv value', '2017-10-13 15:01:54'),
	(72, 2, 1, 'added new detection_spleen value', '2017-10-13 15:01:54'),
	(73, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:01:54'),
	(74, 2, 1, 'added new precursor data set', '2017-10-13 15:05:52'),
	(75, 2, 1, 'added new detection_liver value', '2017-10-13 15:05:52'),
	(76, 2, 1, 'added new splenomegaly value', '2017-10-13 15:05:52'),
	(77, 2, 1, 'added new epo value', '2017-10-13 15:05:52'),
	(78, 2, 1, 'added new pcv value', '2017-10-13 15:05:52'),
	(79, 2, 1, 'added new detection_spleen value', '2017-10-13 15:05:52'),
	(80, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:05:52'),
	(81, 2, 1, 'added new precursor data set', '2017-10-13 15:07:01'),
	(82, 2, 1, 'added new detection_liver value', '2017-10-13 15:07:01'),
	(83, 2, 1, 'added new splenomegaly value', '2017-10-13 15:07:01'),
	(84, 2, 1, 'added new epo value', '2017-10-13 15:07:01'),
	(85, 2, 1, 'added new pcv value', '2017-10-13 15:07:01'),
	(86, 2, 1, 'added new detection_spleen value', '2017-10-13 15:07:01'),
	(87, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:07:01'),
	(88, 2, 1, 'added new precursor data set', '2017-10-13 15:07:56'),
	(89, 2, 1, 'added new detection_liver value', '2017-10-13 15:07:57'),
	(90, 2, 1, 'added new splenomegaly value', '2017-10-13 15:07:57'),
	(91, 2, 1, 'added new epo value', '2017-10-13 15:07:57'),
	(92, 2, 1, 'added new pcv value', '2017-10-13 15:07:57'),
	(93, 2, 1, 'added new detection_spleen value', '2017-10-13 15:07:57'),
	(94, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:07:57'),
	(95, 2, 1, 'deleted precursor dataset', '2017-10-13 15:07:57'),
	(96, 2, 1, 'added new precursor data set', '2017-10-13 15:11:47'),
	(97, 2, 1, 'added new detection_liver value', '2017-10-13 15:11:47'),
	(98, 2, 1, 'added new splenomegaly value', '2017-10-13 15:11:47'),
	(99, 2, 1, 'added new epo value', '2017-10-13 15:11:47'),
	(100, 2, 1, 'added new pcv value', '2017-10-13 15:11:47'),
	(101, 2, 1, 'added new detection_spleen value', '2017-10-13 15:11:47'),
	(102, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:11:47'),
	(103, 2, 1, 'deleted precursor dataset', '2017-10-13 15:11:48'),
	(104, 2, 1, 'added new precursor data set', '2017-10-13 15:12:15'),
	(105, 2, 1, 'added new detection_liver value', '2017-10-13 15:12:15'),
	(106, 2, 1, 'added new splenomegaly value', '2017-10-13 15:12:15'),
	(107, 2, 1, 'added new epo value', '2017-10-13 15:12:15'),
	(108, 2, 1, 'added new pcv value', '2017-10-13 15:12:15'),
	(109, 2, 1, 'added new detection_spleen value', '2017-10-13 15:12:15'),
	(110, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:12:15'),
	(111, 2, 1, 'deleted precursor dataset', '2017-10-13 15:12:15'),
	(112, 2, 1, 'added new precursor data set', '2017-10-13 15:27:43'),
	(113, 2, 1, 'added new detection_liver value', '2017-10-13 15:27:44'),
	(114, 2, 1, 'added new splenomegaly value', '2017-10-13 15:27:44'),
	(115, 2, 1, 'added new epo value', '2017-10-13 15:27:44'),
	(116, 2, 1, 'added new pcv value', '2017-10-13 15:27:44'),
	(117, 2, 1, 'added new detection_spleen value', '2017-10-13 15:27:44'),
	(118, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:27:44'),
	(119, 2, 1, 'deleted precursor dataset', '2017-10-13 15:27:44'),
	(120, 2, 1, 'added new precursor data set', '2017-10-13 15:33:04'),
	(121, 2, 1, 'added new detection_liver value', '2017-10-13 15:33:05'),
	(122, 2, 1, 'added new splenomegaly value', '2017-10-13 15:33:05'),
	(123, 2, 1, 'added new epo value', '2017-10-13 15:33:05'),
	(124, 2, 1, 'added new pcv value', '2017-10-13 15:33:05'),
	(125, 2, 1, 'added new detection_spleen value', '2017-10-13 15:33:05'),
	(126, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:33:05'),
	(127, 2, 1, 'deleted precursor dataset', '2017-10-13 15:33:05'),
	(128, 2, 1, 'added new precursor data set', '2017-10-13 15:33:41'),
	(129, 2, 1, 'added new detection_liver value', '2017-10-13 15:33:42'),
	(130, 2, 1, 'added new splenomegaly value', '2017-10-13 15:33:42'),
	(131, 2, 1, 'added new epo value', '2017-10-13 15:33:42'),
	(132, 2, 1, 'added new pcv value', '2017-10-13 15:33:42'),
	(133, 2, 1, 'added new detection_spleen value', '2017-10-13 15:33:42'),
	(134, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:33:42'),
	(135, 2, 1, 'deleted precursor dataset', '2017-10-13 15:33:42'),
	(136, 2, 1, 'added new precursor data set', '2017-10-13 15:36:09'),
	(137, 2, 1, 'added new detection_liver value', '2017-10-13 15:36:09'),
	(138, 2, 1, 'added new splenomegaly value', '2017-10-13 15:36:09'),
	(139, 2, 1, 'added new epo value', '2017-10-13 15:36:09'),
	(140, 2, 1, 'added new pcv value', '2017-10-13 15:36:09'),
	(141, 2, 1, 'added new detection_spleen value', '2017-10-13 15:36:09'),
	(142, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:36:09'),
	(143, 2, 1, 'deleted precursor dataset', '2017-10-13 15:36:09'),
	(144, 2, 1, 'added new precursor data set', '2017-10-13 15:45:14'),
	(145, 2, 1, 'added new detection_liver value', '2017-10-13 15:45:14'),
	(146, 2, 1, 'added new splenomegaly value', '2017-10-13 15:45:14'),
	(147, 2, 1, 'added new epo value', '2017-10-13 15:45:14'),
	(148, 2, 1, 'added new pcv value', '2017-10-13 15:45:14'),
	(149, 2, 1, 'added new detection_spleen value', '2017-10-13 15:45:14'),
	(150, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:45:14'),
	(151, 2, 1, 'deleted precursor dataset', '2017-10-13 15:45:15'),
	(152, 2, 1, 'added new precursor data set', '2017-10-13 15:46:49'),
	(153, 2, 1, 'added new detection_liver value', '2017-10-13 15:46:49'),
	(154, 2, 1, 'added new splenomegaly value', '2017-10-13 15:46:49'),
	(155, 2, 1, 'added new epo value', '2017-10-13 15:46:49'),
	(156, 2, 1, 'added new pcv value', '2017-10-13 15:46:49'),
	(157, 2, 1, 'added new detection_spleen value', '2017-10-13 15:46:49'),
	(158, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:46:49'),
	(159, 2, 1, 'deleted precursor dataset', '2017-10-13 15:46:49'),
	(160, 2, 1, 'added new precursor data set', '2017-10-13 15:47:12'),
	(161, 2, 1, 'added new detection_liver value', '2017-10-13 15:47:12'),
	(162, 2, 1, 'added new splenomegaly value', '2017-10-13 15:47:12'),
	(163, 2, 1, 'added new epo value', '2017-10-13 15:47:12'),
	(164, 2, 1, 'added new pcv value', '2017-10-13 15:47:12'),
	(165, 2, 1, 'added new detection_spleen value', '2017-10-13 15:47:12'),
	(166, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:47:12'),
	(167, 2, 1, 'deleted precursor dataset', '2017-10-13 15:47:12'),
	(168, 2, 1, 'added new precursor data set', '2017-10-13 15:49:26'),
	(169, 2, 1, 'added new detection_liver value', '2017-10-13 15:49:26'),
	(170, 2, 1, 'added new splenomegaly value', '2017-10-13 15:49:26'),
	(171, 2, 1, 'added new epo value', '2017-10-13 15:49:26'),
	(172, 2, 1, 'added new pcv value', '2017-10-13 15:49:26'),
	(173, 2, 1, 'added new detection_spleen value', '2017-10-13 15:49:26'),
	(174, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:49:26'),
	(175, 2, 1, 'deleted precursor dataset', '2017-10-13 15:49:26'),
	(176, 2, 1, 'added new precursor data set', '2017-10-13 15:50:04'),
	(177, 2, 1, 'added new detection_liver value', '2017-10-13 15:50:04'),
	(178, 2, 1, 'added new splenomegaly value', '2017-10-13 15:50:04'),
	(179, 2, 1, 'added new epo value', '2017-10-13 15:50:04'),
	(180, 2, 1, 'added new pcv value', '2017-10-13 15:50:04'),
	(181, 2, 1, 'added new detection_spleen value', '2017-10-13 15:50:04'),
	(182, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:50:04'),
	(183, 2, 1, 'deleted precursor dataset', '2017-10-13 15:50:05'),
	(184, 2, 1, 'added new precursor data set', '2017-10-13 15:51:29'),
	(185, 2, 1, 'added new detection_liver value', '2017-10-13 15:51:29'),
	(186, 2, 1, 'added new splenomegaly value', '2017-10-13 15:51:29'),
	(187, 2, 1, 'added new epo value', '2017-10-13 15:51:29'),
	(188, 2, 1, 'added new pcv value', '2017-10-13 15:51:29'),
	(189, 2, 1, 'added new detection_spleen value', '2017-10-13 15:51:29'),
	(190, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:51:29'),
	(191, 2, 1, 'deleted precursor dataset', '2017-10-13 15:51:29'),
	(192, 2, 1, 'added new precursor data set', '2017-10-13 15:52:07'),
	(193, 2, 1, 'added new detection_liver value', '2017-10-13 15:52:08'),
	(194, 2, 1, 'added new splenomegaly value', '2017-10-13 15:52:08'),
	(195, 2, 1, 'added new epo value', '2017-10-13 15:52:08'),
	(196, 2, 1, 'added new pcv value', '2017-10-13 15:52:08'),
	(197, 2, 1, 'added new detection_spleen value', '2017-10-13 15:52:08'),
	(198, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:52:08'),
	(199, 2, 1, 'deleted precursor dataset', '2017-10-13 15:52:08'),
	(200, 2, 1, 'added new precursor data set', '2017-10-13 15:55:51'),
	(201, 2, 1, 'added new detection_liver value', '2017-10-13 15:55:52'),
	(202, 2, 1, 'added new splenomegaly value', '2017-10-13 15:55:52'),
	(203, 2, 1, 'added new epo value', '2017-10-13 15:55:52'),
	(204, 2, 1, 'added new pcv value', '2017-10-13 15:55:52'),
	(205, 2, 1, 'added new detection_spleen value', '2017-10-13 15:55:52'),
	(206, 2, 1, 'added new hepatomegaly value', '2017-10-13 15:55:52'),
	(207, 2, 1, 'deleted precursor dataset', '2017-10-13 15:55:52'),
	(208, 2, 1, 'added new precursor data set', '2017-10-13 16:01:48'),
	(209, 2, 1, 'deleted precursor dataset', '2017-10-13 16:01:48'),
	(210, 2, 1, 'added new precursor data set', '2017-10-13 16:03:53'),
	(211, 2, 1, 'deleted precursor dataset', '2017-10-13 16:03:54'),
	(212, 2, 1, 'added new precursor data set', '2017-10-13 16:04:13'),
	(213, 2, 1, 'deleted precursor dataset', '2017-10-13 16:04:14'),
	(214, 2, 1, 'added new precursor data set', '2017-10-13 16:04:57'),
	(215, 2, 1, 'added new detection_liver value', '2017-10-13 16:04:58'),
	(216, 2, 1, 'added new splenomegaly value', '2017-10-13 16:04:58'),
	(217, 2, 1, 'added new epo value', '2017-10-13 16:04:58'),
	(218, 2, 1, 'added new pcv value', '2017-10-13 16:04:58'),
	(219, 2, 1, 'added new detection_spleen value', '2017-10-13 16:04:58'),
	(220, 2, 1, 'added new hepatomegaly value', '2017-10-13 16:04:58'),
	(221, 2, 1, 'deleted precursor dataset', '2017-10-13 16:04:58'),
	(222, 2, 1, 'added new precursor data set', '2017-10-13 16:05:27'),
	(223, 2, 1, 'added new detection_liver value', '2017-10-13 16:05:27'),
	(224, 2, 1, 'added new splenomegaly value', '2017-10-13 16:05:27'),
	(225, 2, 1, 'added new epo value', '2017-10-13 16:05:27'),
	(226, 2, 1, 'added new pcv value', '2017-10-13 16:05:27'),
	(227, 2, 1, 'added new detection_spleen value', '2017-10-13 16:05:27'),
	(228, 2, 1, 'added new hepatomegaly value', '2017-10-13 16:05:27'),
	(229, 2, 1, 'deleted precursor dataset', '2017-10-13 16:05:27'),
	(230, 2, 1, 'added new precursor data set', '2017-10-13 16:09:00'),
	(231, 2, 1, 'added new detection_liver value', '2017-10-13 16:09:00'),
	(232, 2, 1, 'added new splenomegaly value', '2017-10-13 16:09:00'),
	(233, 2, 1, 'added new epo value', '2017-10-13 16:09:00'),
	(234, 2, 1, 'added new pcv value', '2017-10-13 16:09:00'),
	(235, 2, 1, 'added new detection_spleen value', '2017-10-13 16:09:00'),
	(236, 2, 1, 'added new hepatomegaly value', '2017-10-13 16:09:00'),
	(237, 2, 1, 'deleted precursor dataset', '2017-10-13 16:09:01'),
	(238, 2, 1, 'added new precursor data set', '2017-10-13 16:10:08'),
	(239, 2, 1, 'added new detection_liver value', '2017-10-13 16:10:08'),
	(240, 2, 1, 'added new splenomegaly value', '2017-10-13 16:10:08'),
	(241, 2, 1, 'added new epo value', '2017-10-13 16:10:08'),
	(242, 2, 1, 'added new pcv value', '2017-10-13 16:10:08'),
	(243, 2, 1, 'added new detection_spleen value', '2017-10-13 16:10:08'),
	(244, 2, 1, 'added new hepatomegaly value', '2017-10-13 16:10:08'),
	(245, 2, 1, 'added new precursor data set', '2017-10-13 16:30:26'),
	(246, 2, 1, 'added new detection_liver value', '2017-10-13 16:30:26'),
	(247, 2, 1, 'added new splenomegaly value', '2017-10-13 16:30:26'),
	(248, 2, 1, 'added new epo value', '2017-10-13 16:30:26'),
	(249, 2, 1, 'added new pcv value', '2017-10-13 16:30:26'),
	(250, 2, 1, 'added new detection_spleen value', '2017-10-13 16:30:26'),
	(251, 2, 1, 'added new hepatomegaly value', '2017-10-13 16:30:26'),
	(252, 2, 1, 'deleted precursor dataset', '2017-10-13 16:30:27'),
	(253, 2, 1, 'added new precursor data set', '2017-10-13 16:31:41'),
	(254, 2, 1, 'added new detection_liver value', '2017-10-13 16:31:41'),
	(255, 2, 1, 'added new splenomegaly value', '2017-10-13 16:31:41'),
	(256, 2, 1, 'added new epo value', '2017-10-13 16:31:41'),
	(257, 2, 1, 'added new pcv value', '2017-10-13 16:31:41'),
	(258, 2, 1, 'added new detection_spleen value', '2017-10-13 16:31:41'),
	(259, 2, 1, 'added new hepatomegaly value', '2017-10-13 16:31:41'),
	(260, 2, 1, 'deleted precursor dataset', '2017-10-13 16:31:41'),
	(261, 2, 1, 'added new precursor data set', '2017-10-13 16:33:34'),
	(262, 2, 1, 'added new detection_liver value', '2017-10-13 16:33:34'),
	(263, 2, 1, 'added new splenomegaly value', '2017-10-13 16:33:34'),
	(264, 2, 1, 'added new epo value', '2017-10-13 16:33:34'),
	(265, 2, 1, 'added new pcv value', '2017-10-13 16:33:34'),
	(266, 2, 1, 'added new detection_spleen value', '2017-10-13 16:33:34'),
	(267, 2, 1, 'added new hepatomegaly value', '2017-10-13 16:33:34'),
	(268, 2, 1, 'added new precursor data set', '2017-10-13 16:34:21'),
	(269, 2, 1, 'added new detection_liver value', '2017-10-13 16:34:21'),
	(270, 2, 1, 'added new splenomegaly value', '2017-10-13 16:34:21'),
	(271, 2, 1, 'added new epo value', '2017-10-13 16:34:21'),
	(272, 2, 1, 'added new pcv value', '2017-10-13 16:34:21'),
	(273, 2, 1, 'added new detection_spleen value', '2017-10-13 16:34:21'),
	(274, 2, 1, 'added new hepatomegaly value', '2017-10-13 16:34:21'),
	(275, 2, 1, 'deleted precursor dataset', '2017-10-13 16:34:22'),
	(276, 2, 1, 'added new precursor data set', '2017-10-13 16:37:28'),
	(277, 2, 1, 'added new detection_liver value', '2017-10-13 16:37:28'),
	(278, 2, 1, 'added new splenomegaly value', '2017-10-13 16:37:28'),
	(279, 2, 1, 'added new epo value', '2017-10-13 16:37:28'),
	(280, 2, 1, 'added new pcv value', '2017-10-13 16:37:28'),
	(281, 2, 1, 'added new detection_spleen value', '2017-10-13 16:37:28'),
	(282, 2, 1, 'added new hepatomegaly value', '2017-10-13 16:37:28'),
	(283, 2, 1, 'deleted precursor dataset', '2017-10-13 16:37:29'),
	(284, 2, 1, 'added new precursor data set', '2017-10-13 16:41:32'),
	(285, 2, 1, 'added new detection_liver value', '2017-10-13 16:41:32'),
	(286, 2, 1, 'added new splenomegaly value', '2017-10-13 16:41:32'),
	(287, 2, 1, 'added new epo value', '2017-10-13 16:41:32'),
	(288, 2, 1, 'added new pcv value', '2017-10-13 16:41:32'),
	(289, 2, 1, 'added new detection_spleen value', '2017-10-13 16:41:32'),
	(290, 2, 1, 'added new hepatomegaly value', '2017-10-13 16:41:32'),
	(291, 2, 1, 'deleted precursor dataset', '2017-10-13 16:41:33'),
	(292, 2, 1, 'added new precursor data set', '2017-10-13 16:49:42'),
	(293, 2, 1, 'added new detection_liver value', '2017-10-13 16:49:42'),
	(294, 2, 1, 'added new splenomegaly value', '2017-10-13 16:49:42'),
	(295, 2, 1, 'added new epo value', '2017-10-13 16:49:42'),
	(296, 2, 1, 'added new pcv value', '2017-10-13 16:49:42'),
	(297, 2, 1, 'added new detection_spleen value', '2017-10-13 16:49:42'),
	(298, 2, 1, 'added new hepatomegaly value', '2017-10-13 16:49:42'),
	(299, 2, 1, 'deleted precursor dataset', '2017-10-13 16:49:43'),
	(300, 2, 1, 'added new precursor data set', '2017-10-13 17:08:16'),
	(301, 2, 1, 'added new detection_liver value', '2017-10-13 17:08:16'),
	(302, 2, 1, 'added new splenomegaly value', '2017-10-13 17:08:16'),
	(303, 2, 1, 'added new epo value', '2017-10-13 17:08:16'),
	(304, 2, 1, 'added new pcv value', '2017-10-13 17:08:16'),
	(305, 2, 1, 'added new detection_spleen value', '2017-10-13 17:08:16'),
	(306, 2, 1, 'added new hepatomegaly value', '2017-10-13 17:08:16'),
	(307, 2, 1, 'deleted precursor dataset', '2017-10-13 17:08:16'),
	(308, 2, 1, 'added new precursor data set', '2017-10-16 17:55:03'),
	(309, 2, 1, 'added new detection_liver value', '2017-10-16 17:55:04'),
	(310, 2, 1, 'added new splenomegaly value', '2017-10-16 17:55:04'),
	(311, 2, 1, 'added new epo value', '2017-10-16 17:55:04'),
	(312, 2, 1, 'added new pcv value', '2017-10-16 17:55:04'),
	(313, 2, 1, 'added new detection_spleen value', '2017-10-16 17:55:04'),
	(314, 2, 1, 'added new hepatomegaly value', '2017-10-16 17:55:04'),
	(315, 2, 1, 'deleted precursor dataset', '2017-10-16 17:55:04'),
	(316, 2, 1, 'added new precursor data set', '2017-10-18 16:43:41'),
	(317, 2, 1, 'added new detection_liver value', '2017-10-18 16:43:42'),
	(318, 2, 1, 'added new splenomegaly value', '2017-10-18 16:43:42'),
	(319, 2, 1, 'added new epo value', '2017-10-18 16:43:42'),
	(320, 2, 1, 'added new pcv value', '2017-10-18 16:43:42'),
	(321, 2, 1, 'added new detection_spleen value', '2017-10-18 16:43:42'),
	(322, 2, 1, 'added new hepatomegaly value', '2017-10-18 16:43:42'),
	(323, 2, 1, 'deleted precursor dataset', '2017-10-18 16:43:42'),
	(324, 2, 1, 'added new precursor data set', '2017-10-24 20:54:57'),
	(325, 2, 1, 'added new detection_liver value', '2017-10-24 20:54:57'),
	(326, 2, 1, 'added new splenomegaly value', '2017-10-24 20:54:57'),
	(327, 2, 1, 'added new epo value', '2017-10-24 20:54:57'),
	(328, 2, 1, 'added new pcv value', '2017-10-24 20:54:57'),
	(329, 2, 1, 'added new detection_spleen value', '2017-10-24 20:54:57'),
	(330, 2, 1, 'added new hepatomegaly value', '2017-10-24 20:54:57'),
	(331, 2, 1, 'deleted precursor dataset', '2017-10-24 20:54:58'),
	(332, 2, 1, 'added new precursor data set', '2017-11-03 16:15:58'),
	(333, 2, 1, 'added new detection_liver value', '2017-11-03 16:15:58'),
	(334, 2, 1, 'added new splenomegaly value', '2017-11-03 16:15:58'),
	(335, 2, 1, 'added new epo value', '2017-11-03 16:15:58'),
	(336, 2, 1, 'added new pcv value', '2017-11-03 16:15:58'),
	(337, 2, 1, 'added new detection_spleen value', '2017-11-03 16:15:58'),
	(338, 2, 1, 'added new hepatomegaly value', '2017-11-03 16:15:58'),
	(339, 2, 1, 'deleted precursor dataset', '2017-11-03 16:15:58');
/*!40000 ALTER TABLE `history` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.imaging_options
CREATE TABLE IF NOT EXISTS `imaging_options` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(50) NOT NULL DEFAULT '',
  `option_type` enum('upper_nodal','lower_nodal','extranodal','flag') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.imaging_options: ~42 rows (approximately)
/*!40000 ALTER TABLE `imaging_options` DISABLE KEYS */;
INSERT INTO `imaging_options` (`id`, `description`, `option_type`) VALUES
	(1, 'cns', 'extranodal'),
	(2, 'git', 'extranodal'),
	(3, 'gu', 'extranodal'),
	(4, 'blood', 'extranodal'),
	(5, 'bone', 'extranodal'),
	(6, 'liver', 'extranodal'),
	(7, 'pulmonary_left', 'extranodal'),
	(8, 'pulmonary_right', 'extranodal'),
	(9, 'marrow', 'extranodal'),
	(10, 'orbit_left', 'extranodal'),
	(11, 'orbit_right', 'extranodal'),
	(12, 'skin', 'extranodal'),
	(13, 'salivary_gland_left', 'extranodal'),
	(14, 'salivary_gland_right', 'extranodal'),
	(15, 'thyroid', 'extranodal'),
	(16, 'pericardium', 'extranodal'),
	(17, 'muscle', 'extranodal'),
	(18, 'waldeyer', 'upper_nodal'),
	(19, 'neck_left', 'upper_nodal'),
	(20, 'neck_right', 'upper_nodal'),
	(21, 'infraclavicular_left', 'upper_nodal'),
	(22, 'infraclavicular_right', 'upper_nodal'),
	(23, 'axillary_left', 'upper_nodal'),
	(24, 'axillary_right', 'upper_nodal'),
	(25, 'arm_left', 'upper_nodal'),
	(26, 'arm_right', 'upper_nodal'),
	(27, 'thymus', 'upper_nodal'),
	(28, 'mediastinal', 'upper_nodal'),
	(29, 'hilar_left', 'upper_nodal'),
	(30, 'hilar_right', 'upper_nodal'),
	(31, 'para_aortic', 'lower_nodal'),
	(32, 'mesenteric', 'lower_nodal'),
	(33, 'iliac_left', 'lower_nodal'),
	(34, 'iliac_right', 'lower_nodal'),
	(35, 'inguinal_left', 'lower_nodal'),
	(36, 'inguinal_right', 'lower_nodal'),
	(37, 'popliteal_left', 'lower_nodal'),
	(38, 'popliteal_right', 'lower_nodal'),
	(39, 'spleen', 'lower_nodal'),
	(40, 'extensive', 'flag'),
	(41, 'bulky', 'flag'),
	(42, 'check_scan', 'flag');
/*!40000 ALTER TABLE `imaging_options` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.locations
CREATE TABLE IF NOT EXISTS `locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `location` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.locations: ~17 rows (approximately)
/*!40000 ALTER TABLE `locations` DISABLE KEYS */;
INSERT INTO `locations` (`id`, `location`) VALUES
	(1, 'Hull'),
	(2, 'Mid-Yorks'),
	(3, 'York'),
	(4, 'Leeds'),
	(5, 'Airedale'),
	(6, 'Calderdale'),
	(7, 'Harrogate'),
	(8, 'Scarborough'),
	(9, 'Bradford'),
	(10, 'Middlesborough'),
	(11, 'Scunthorpe'),
	(12, 'Grimsby (DPW)'),
	(13, 'Nottingham'),
	(14, 'Lincoln County'),
	(15, 'Newcastle'),
	(16, 'Sheffield'),
	(17, 'Christie');
/*!40000 ALTER TABLE `locations` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.menu_items
CREATE TABLE IF NOT EXISTS `menu_items` (
  `item_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `item_value` varchar(255) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_id`),
  UNIQUE KEY `item_value` (`item_value`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.menu_items: ~59 rows (approximately)
/*!40000 ALTER TABLE `menu_items` DISABLE KEYS */;
INSERT INTO `menu_items` (`item_id`, `item_value`) VALUES
	(1, '0'),
	(2, '1'),
	(3, '2'),
	(4, '3'),
	(31, '4'),
	(5, '7'),
	(32, '8'),
	(33, '9'),
	(17, 'A'),
	(18, 'B'),
	(13, 'both'),
	(19, 'C'),
	(26, 'equivocal'),
	(45, 'good'),
	(36, 'I'),
	(37, 'IE'),
	(48, 'IgA'),
	(53, 'IgA & IgG'),
	(49, 'IgD'),
	(50, 'IgE'),
	(51, 'IgG'),
	(54, 'IgG & IgM'),
	(52, 'IgM'),
	(38, 'II'),
	(39, 'IIE'),
	(41, 'III'),
	(42, 'IIIE'),
	(43, 'IIIS'),
	(40, 'IIS'),
	(46, 'intermediate'),
	(44, 'IV'),
	(58, 'kappa'),
	(59, 'lambda'),
	(55, 'light-chain only'),
	(6, 'low'),
	(20, 'lytic'),
	(35, 'multiple'),
	(24, 'multiple fractures'),
	(25, 'multiple types'),
	(15, 'N'),
	(30, 'no'),
	(56, 'non-secretory'),
	(27, 'none'),
	(7, 'normal'),
	(10, 'not done'),
	(21, 'osteopenia'),
	(22, 'osteoporosis'),
	(11, 'palpation'),
	(28, 'plasmacytoma'),
	(47, 'poor'),
	(8, 'raised'),
	(34, 'single'),
	(23, 'single fracture'),
	(57, 'suppressed'),
	(16, 'U'),
	(12, 'ultrasound'),
	(9, 'unknown'),
	(14, 'Y'),
	(29, 'yes');
/*!40000 ALTER TABLE `menu_items` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.parameters
CREATE TABLE IF NOT EXISTS `parameters` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `param_name` varchar(25) NOT NULL DEFAULT '',
  `field_type` enum('int','decimal','menu') NOT NULL DEFAULT 'int',
  `is_active` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  UNIQUE KEY `param_name` (`param_name`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table hmrn_test.parameters: ~47 rows (approximately)
/*!40000 ALTER TABLE `parameters` DISABLE KEYS */;
INSERT INTO `parameters` (`id`, `param_name`, `field_type`, `is_active`) VALUES
	(1, 'cns', 'menu', 'yes'),
	(2, 'bone_disease', 'menu', 'yes'),
	(3, 'paraprotein', 'menu', 'yes'),
	(4, 'pp_level', 'decimal', 'yes'),
	(5, 'bence_jones', 'menu', 'yes'),
	(6, 'hb', 'decimal', 'yes'),
	(7, 'b2m', 'decimal', 'yes'),
	(8, 'creatinine', 'int', 'yes'),
	(9, 'igs', 'menu', 'yes'),
	(10, 'free_chains', 'menu', 'yes'),
	(11, 'skeletal_survey', 'menu', 'yes'),
	(12, 'mri', 'menu', 'yes'),
	(13, 'bone_lesions', 'menu', 'yes'),
	(14, 'serum_kappa', 'decimal', 'yes'),
	(15, 'serum_lambda', 'decimal', 'yes'),
	(16, 'ecog', 'menu', 'yes'),
	(17, 'ldh', 'menu', 'yes'),
	(18, 'wbc', 'decimal', 'yes'),
	(19, 'lymphs', 'decimal', 'yes'),
	(20, 'albumin', 'int', 'yes'),
	(21, 'ct', 'menu', 'yes'),
	(22, 'bm', 'menu', 'yes'),
	(23, 'sweats', 'menu', 'yes'),
	(24, 'wt_loss', 'menu', 'yes'),
	(25, 'fever', 'menu', 'yes'),
	(26, 'binet', 'menu', 'yes'),
	(27, 'stage', 'menu', 'yes'),
	(28, 'plts', 'int', 'yes'),
	(29, 'splenomegaly', 'menu', 'yes'),
	(30, 'hepatomegaly', 'menu', 'yes'),
	(31, 'detection_spleen', 'menu', 'yes'),
	(32, 'detection_liver', 'menu', 'yes'),
	(33, 'epo', 'menu', 'yes'),
	(34, 'rcm', 'menu', 'yes'),
	(35, 'cytopenias', 'menu', 'yes'),
	(36, 'karyotype', 'menu', 'yes'),
	(37, 'cd34', 'decimal', 'yes'),
	(38, 'transfusion', 'menu', 'yes'),
	(39, 'calcium', 'decimal', 'yes'),
	(40, 'monocytes', 'decimal', 'yes'),
	(41, 'neutrophils', 'decimal', 'yes'),
	(42, 'pcv', 'decimal', 'yes'),
	(43, 'deauville', 'int', 'yes'),
	(44, 'suv_max', 'decimal', 'yes'),
	(45, 'serum_flc', 'menu', 'yes'),
	(46, 'haematocrit_vol', 'decimal', 'yes'),
	(47, 'kappa_lambda_ratio', 'decimal', 'yes');
/*!40000 ALTER TABLE `parameters` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.parameter_menu_item
CREATE TABLE IF NOT EXISTS `parameter_menu_item` (
  `param_id` smallint(5) unsigned NOT NULL,
  `item_id` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`param_id`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.parameter_menu_item: ~132 rows (approximately)
/*!40000 ALTER TABLE `parameter_menu_item` DISABLE KEYS */;
INSERT INTO `parameter_menu_item` (`param_id`, `item_id`) VALUES
	(1, 14),
	(1, 15),
	(1, 16),
	(2, 9),
	(2, 20),
	(2, 21),
	(2, 22),
	(2, 23),
	(2, 24),
	(2, 25),
	(2, 26),
	(2, 27),
	(2, 28),
	(2, 29),
	(2, 30),
	(3, 9),
	(3, 27),
	(3, 48),
	(3, 49),
	(3, 50),
	(3, 51),
	(3, 52),
	(3, 53),
	(3, 54),
	(3, 55),
	(3, 56),
	(5, 9),
	(5, 10),
	(5, 13),
	(5, 27),
	(5, 58),
	(5, 59),
	(9, 7),
	(9, 8),
	(9, 9),
	(9, 57),
	(10, 14),
	(10, 15),
	(10, 16),
	(11, 14),
	(11, 15),
	(11, 16),
	(12, 14),
	(12, 15),
	(12, 16),
	(13, 9),
	(13, 27),
	(13, 34),
	(13, 35),
	(16, 1),
	(16, 2),
	(16, 3),
	(16, 4),
	(16, 31),
	(16, 32),
	(16, 33),
	(17, 6),
	(17, 7),
	(17, 8),
	(17, 9),
	(17, 10),
	(21, 14),
	(21, 15),
	(21, 16),
	(22, 14),
	(22, 15),
	(22, 16),
	(23, 14),
	(23, 15),
	(23, 16),
	(24, 14),
	(24, 15),
	(24, 16),
	(25, 14),
	(25, 15),
	(25, 16),
	(26, 16),
	(26, 17),
	(26, 18),
	(26, 19),
	(27, 16),
	(27, 36),
	(27, 37),
	(27, 38),
	(27, 39),
	(27, 40),
	(27, 41),
	(27, 42),
	(27, 43),
	(27, 44),
	(29, 14),
	(29, 15),
	(29, 16),
	(30, 14),
	(30, 15),
	(30, 16),
	(31, 9),
	(31, 11),
	(31, 12),
	(31, 13),
	(32, 9),
	(32, 11),
	(32, 12),
	(32, 13),
	(33, 6),
	(33, 7),
	(33, 8),
	(33, 9),
	(33, 10),
	(34, 6),
	(34, 7),
	(34, 8),
	(34, 9),
	(34, 10),
	(35, 1),
	(35, 2),
	(35, 3),
	(35, 4),
	(35, 5),
	(36, 9),
	(36, 45),
	(36, 46),
	(36, 47),
	(38, 14),
	(38, 15),
	(38, 16),
	(45, 9),
	(45, 10),
	(45, 13),
	(45, 27),
	(45, 58),
	(45, 59);
/*!40000 ALTER TABLE `parameter_menu_item` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_antecedent
CREATE TABLE IF NOT EXISTS `patient_antecedent` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `event_id` int(11) NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`patient_id`),
  KEY `event_id` (`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_antecedent: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_antecedent` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_antecedent` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_chronologies
CREATE TABLE IF NOT EXISTS `patient_chronologies` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `diagnosed` date DEFAULT NULL,
  `first_appointment` date DEFAULT NULL,
  `palliative_care` date DEFAULT NULL,
  `deceased` date DEFAULT NULL,
  PRIMARY KEY (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_chronologies: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_chronologies` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_chronologies` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_comments
CREATE TABLE IF NOT EXISTS `patient_comments` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `comment` text NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_comments: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_comments` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_event
CREATE TABLE IF NOT EXISTS `patient_event` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `event_id` smallint(6) NOT NULL DEFAULT '0',
  `date` date DEFAULT NULL,
  PRIMARY KEY (`patient_id`,`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_event: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_event` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_event` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_imaging_event
CREATE TABLE IF NOT EXISTS `patient_imaging_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `dataset` smallint(6) NOT NULL DEFAULT '1',
  `scan_type` enum('ct','pet') DEFAULT NULL,
  `stage` enum('initial','follow-up') NOT NULL DEFAULT 'initial',
  `date` date NOT NULL DEFAULT '1901-01-01',
  PRIMARY KEY (`id`),
  UNIQUE KEY `patient_dataset_type` (`patient_id`,`dataset`,`scan_type`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_imaging_event: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_imaging_event` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_imaging_event` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_imaging_option
CREATE TABLE IF NOT EXISTS `patient_imaging_option` (
  `imaging_event_id` int(11) NOT NULL DEFAULT '0',
  `imaging_option_id` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`imaging_event_id`,`imaging_option_id`),
  KEY `imaging_options` (`imaging_option_id`),
  CONSTRAINT `fk_patient_imaging_option_imaging_options` FOREIGN KEY (`imaging_option_id`) REFERENCES `imaging_options` (`id`),
  CONSTRAINT `fk_patient_imaging_option_patient_imaging_event` FOREIGN KEY (`imaging_event_id`) REFERENCES `patient_imaging_event` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_imaging_option: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_imaging_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_imaging_option` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_imaging_other
CREATE TABLE IF NOT EXISTS `patient_imaging_other` (
  `imaging_event_id` int(11) NOT NULL DEFAULT '0',
  `details` varchar(255) NOT NULL DEFAULT '',
  KEY `imaging_event_id` (`imaging_event_id`),
  CONSTRAINT `fk_patient_imaging_other_patient_imaging_event` FOREIGN KEY (`imaging_event_id`) REFERENCES `patient_imaging_event` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_imaging_other: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_imaging_other` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_imaging_other` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_mdt_dates
CREATE TABLE IF NOT EXISTS `patient_mdt_dates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `date` date DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_mdt_dates: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_mdt_dates` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_mdt_dates` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_params
CREATE TABLE IF NOT EXISTS `patient_params` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `param_id` smallint(6) NOT NULL DEFAULT '0',
  `result` varchar(255) NOT NULL DEFAULT '',
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`patient_id`,`param_id`),
  KEY `param_id` (`param_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table hmrn_test.patient_params: ~6 rows (approximately)
/*!40000 ALTER TABLE `patient_params` DISABLE KEYS */;
INSERT INTO `patient_params` (`patient_id`, `param_id`, `result`, `time`) VALUES
	(2, 29, 'Y', '2017-11-03 16:15:58'),
	(2, 30, 'N', '2017-11-03 16:15:58'),
	(2, 31, 'both', '2017-11-03 16:15:58'),
	(2, 32, 'both', '2017-11-03 16:15:58'),
	(2, 33, 'low', '2017-11-03 16:15:58'),
	(2, 42, '60', '2017-11-03 16:15:58');
/*!40000 ALTER TABLE `patient_params` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_pet_score
CREATE TABLE IF NOT EXISTS `patient_pet_score` (
  `imaging_event_id` int(11) NOT NULL DEFAULT '0',
  `param` enum('suv_max','deauville') NOT NULL DEFAULT 'suv_max',
  `result` float DEFAULT NULL,
  PRIMARY KEY (`imaging_event_id`,`param`),
  CONSTRAINT `fk_patient_pet_scan_patient_imaging_event` FOREIGN KEY (`imaging_event_id`) REFERENCES `patient_imaging_event` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_pet_score: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_pet_score` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_pet_score` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_post_code
CREATE TABLE IF NOT EXISTS `patient_post_code` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `post_code` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_post_code: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_post_code` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_post_code` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_prior_therapies
CREATE TABLE IF NOT EXISTS `patient_prior_therapies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `therapy` enum('radiotherapy','chemotherapy') DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_prior_therapies: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_prior_therapies` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_prior_therapies` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_referrals
CREATE TABLE IF NOT EXISTS `patient_referrals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `referral_date` date DEFAULT NULL,
  `referral_type_id` smallint(6) NOT NULL DEFAULT '0',
  `from_source_id` smallint(6) NOT NULL DEFAULT '0',
  `to_source_id` smallint(6) NOT NULL DEFAULT '0',
  `date_first_seen` date DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `pid` (`patient_id`),
  KEY `FK_referral_type_options` (`referral_type_id`),
  KEY `FK_referral_source_from_options` (`from_source_id`),
  KEY `FK_referral_source_to_options` (`to_source_id`),
  CONSTRAINT `FK_referral_source_from_options` FOREIGN KEY (`from_source_id`) REFERENCES `referral_source_options` (`id`),
  CONSTRAINT `FK_referral_source_to_options` FOREIGN KEY (`to_source_id`) REFERENCES `referral_source_options` (`id`),
  CONSTRAINT `FK_referral_type_options` FOREIGN KEY (`referral_type_id`) REFERENCES `referral_type_options` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_referrals: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_referrals` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_referrals` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_sites_other
CREATE TABLE IF NOT EXISTS `patient_sites_other` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `details` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_sites_other: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_sites_other` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_sites_other` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_staging_other
CREATE TABLE IF NOT EXISTS `patient_staging_other` (
  `patient_id` int(10) NOT NULL DEFAULT '0',
  `detail` enum('bulky','extensive','check_ct') DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_staging_other: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_staging_other` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_staging_other` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_staging_site
CREATE TABLE IF NOT EXISTS `patient_staging_site` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `site_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`patient_id`,`site_id`),
  KEY `site_id` (`site_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_staging_site: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_staging_site` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_staging_site` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_treatment
CREATE TABLE IF NOT EXISTS `patient_treatment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `location_id` int(11) NOT NULL DEFAULT '0',
  `tx_type_id` int(11) NOT NULL DEFAULT '0',
  `tx_detail_id` int(11) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `response_id` int(11) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `pid` (`patient_id`),
  KEY `location_id` (`location_id`),
  KEY `tx_type_id` (`tx_type_id`),
  KEY `tx_detail_id` (`tx_detail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_treatment: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_treatment` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_treatment` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.referral_source_options
CREATE TABLE IF NOT EXISTS `referral_source_options` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=128 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.referral_source_options: ~77 rows (approximately)
/*!40000 ALTER TABLE `referral_source_options` DISABLE KEYS */;
INSERT INTO `referral_source_options` (`id`, `description`) VALUES
	(1, 'A&E - GP referral'),
	(2, 'A&E - Self referral'),
	(3, 'A&E - Unknown referral source'),
	(4, 'Acute assessment unit (AAU etc.)'),
	(5, 'Breast surgery'),
	(6, 'Cardiology'),
	(7, 'Cardiothoracic surgery'),
	(8, 'Colorectal surgery'),
	(9, 'Coronary Care Unit (CCU)'),
	(10, 'Dentist'),
	(11, 'Dermatology'),
	(12, 'Elderly medicine '),
	(13, 'Endocrinology/Diabetes'),
	(14, 'Endoscopy'),
	(15, 'ENT (Ear, Nose & Throat)'),
	(16, 'Gastroenterology'),
	(17, 'Gastro-intestinal surgery'),
	(18, 'General surgery'),
	(19, 'GP'),
	(20, 'Gynaecology'),
	(21, 'Haematology'),
	(22, 'High Dependency Unit (HDU)'),
	(23, 'Intensive Care Unit (ICU)'),
	(24, 'Infectious diseases'),
	(25, 'Maxillo-facial surgery'),
	(26, 'Medicine (general)'),
	(27, 'Neuro-medicine'),
	(28, 'Neuro-surgery'),
	(29, 'Obstetrics '),
	(30, 'Oncology'),
	(31, 'Opthalmology'),
	(32, 'Optician'),
	(33, 'Orthopaedic'),
	(34, 'Other'),
	(35, 'Paediatrics'),
	(36, 'Pain team'),
	(37, 'Palliative medicine'),
	(38, 'Plastic/Reconstructive surgery'),
	(39, 'Psychiatry'),
	(40, 'Psycho-oncology'),
	(41, 'Renal medicine'),
	(42, 'Respiratory medicine'),
	(43, 'Rheumatology'),
	(44, 'Unknown'),
	(45, 'Urology'),
	(46, 'Vascular surgery'),
	(47, 'Referred to'),
	(48, 'Pathology'),
	(49, 'Physiotherapy'),
	(50, 'Radiology'),
	(51, 'Medical oncology'),
	(52, 'Gynaecological oncology'),
	(53, 'Clinical oncology'),
	(54, 'Medical assessment unit'),
	(55, 'Sarcoma specialist'),
	(56, 'Self referral'),
	(57, 'Immunology'),
	(58, 'Physiotherapy'),
	(59, 'Hepatology'),
	(60, 'Head & neck surgery'),
	(61, 'Paediatric oncology'),
	(62, 'Laboratory'),
	(63, 'Known to haematology'),
	(64, 'Paediatric haematologist'),
	(65, 'Paediatric'),
	(66, 'Stroke'),
	(67, 'Spinal'),
	(68, 'A&E'),
	(69, 'Midwifery'),
	(70, 'Haematology (private)'),
	(71, 'GP out of hours'),
	(72, 'Haematology – teenage unit'),
	(73, 'Rehabilitation'),
	(74, 'Neuro-oncology'),
	(75, 'Cranio-facial'),
	(76, 'Medical oncology (private) '),
	(77, 'Neurologist (private) ');
/*!40000 ALTER TABLE `referral_source_options` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.referral_type_options
CREATE TABLE IF NOT EXISTS `referral_type_options` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.referral_type_options: ~5 rows (approximately)
/*!40000 ALTER TABLE `referral_type_options` DISABLE KEYS */;
INSERT INTO `referral_type_options` (`id`, `description`) VALUES
	(1, 'Routine'),
	(2, '2WW/Urgent'),
	(3, 'Consultant'),
	(4, 'Unknown'),
	(5, 'Other');
/*!40000 ALTER TABLE `referral_type_options` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.response_options
CREATE TABLE IF NOT EXISTS `response_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.response_options: ~12 rows (approximately)
/*!40000 ALTER TABLE `response_options` DISABLE KEYS */;
INSERT INTO `response_options` (`id`, `description`) VALUES
	(1, 'CR'),
	(2, 'PR'),
	(3, 'SD'),
	(4, 'PD'),
	(5, 'NE'),
	(6, 'sCR'),
	(7, 'VGPR'),
	(8, 'MR'),
	(9, 'Plateau'),
	(10, 'Relapse'),
	(11, 'RfCR'),
	(12, 'MRD+ve');
/*!40000 ALTER TABLE `response_options` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.staging_sites
CREATE TABLE IF NOT EXISTS `staging_sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL DEFAULT '',
  `location` enum('upper_nodal','lower_nodal','nodal','extranodal') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.staging_sites: ~39 rows (approximately)
/*!40000 ALTER TABLE `staging_sites` DISABLE KEYS */;
INSERT INTO `staging_sites` (`id`, `description`, `location`) VALUES
	(1, 'cns', 'extranodal'),
	(2, 'git', 'extranodal'),
	(3, 'gu', 'extranodal'),
	(4, 'blood', 'extranodal'),
	(5, 'bone', 'extranodal'),
	(6, 'liver', 'extranodal'),
	(7, 'pulmonary_left', 'extranodal'),
	(8, 'pulmonary_right', 'extranodal'),
	(9, 'marrow', 'extranodal'),
	(10, 'orbit_left', 'extranodal'),
	(11, 'orbit_right', 'extranodal'),
	(12, 'skin', 'extranodal'),
	(13, 'salivary_gland_left', 'extranodal'),
	(14, 'salivary_gland_right', 'extranodal'),
	(15, 'thyroid', 'extranodal'),
	(16, 'pericardium', 'extranodal'),
	(17, 'muscle', 'extranodal'),
	(18, 'waldeyer', 'upper_nodal'),
	(19, 'neck_left', 'upper_nodal'),
	(20, 'neck_right', 'upper_nodal'),
	(21, 'infraclavicular_left', 'upper_nodal'),
	(22, 'infraclavicular_right', 'upper_nodal'),
	(23, 'axillary_left', 'upper_nodal'),
	(24, 'axillary_right', 'upper_nodal'),
	(25, 'arm_left', 'upper_nodal'),
	(26, 'arm_right', 'upper_nodal'),
	(27, 'thymus', 'upper_nodal'),
	(28, 'mediastinal', 'upper_nodal'),
	(29, 'hilar_left', 'upper_nodal'),
	(30, 'hilar_right', 'upper_nodal'),
	(31, 'para_aortic', 'lower_nodal'),
	(32, 'mesenteric', 'lower_nodal'),
	(33, 'iliac_left', 'lower_nodal'),
	(34, 'iliac_right', 'lower_nodal'),
	(35, 'inguinal_left', 'lower_nodal'),
	(36, 'inguinal_right', 'lower_nodal'),
	(37, 'popliteal_left', 'lower_nodal'),
	(38, 'popliteal_right', 'lower_nodal'),
	(39, 'spleen', 'lower_nodal');
/*!40000 ALTER TABLE `staging_sites` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.treatment_details
CREATE TABLE IF NOT EXISTS `treatment_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL DEFAULT '',
  `type_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`,`type_id`),
  KEY `type_id` (`type_id`),
  CONSTRAINT `treatment_details_ibfk_1` FOREIGN KEY (`type_id`) REFERENCES `treatment_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2048 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.treatment_details: ~1,331 rows (approximately)
/*!40000 ALTER TABLE `treatment_details` DISABLE KEYS */;
INSERT INTO `treatment_details` (`id`, `description`, `type_id`) VALUES
	(1, 'ABCM', 3),
	(2, 'ABD', 3),
	(3, 'ABT-199', 6),
	(4, 'ABVD', 3),
	(5, 'ABVD / IFRT', 3),
	(6, 'ABVD / Rituximab', 3),
	(7, 'AC220-02', 6),
	(8, 'ACE CL001: ACP-196', 6),
	(9, 'ACE CL006: Acalabrutinib (ACP-196)', 6),
	(10, 'ACE CL006: Ibrutinib', 6),
	(11, 'ACE CL007: Acalabrutinib (ACP-196)', 6),
	(12, 'ACE CL007: Obinutuzumab / Acalabrutinib (ACP-196)', 6),
	(13, 'ACE CL007: Obinutuzumab / Chlorambucil', 6),
	(14, 'Acerta: ACP-196 (Acalabrutinib)', 6),
	(15, 'Acerta: ACP-196 (Ibrutinib)', 6),
	(16, 'ADE', 3),
	(17, 'ADE / Mylotarg', 3),
	(18, 'ADMIRE (CTRU)', 6),
	(19, 'ADMIRE: FCM-R', 6),
	(20, 'ADMIRE: FCR', 6),
	(21, 'AETHERA (SGN-35)', 6),
	(22, 'AG221: AG221', 6),
	(23, 'AIDA', 3),
	(24, 'AITL (NCRI)', 6),
	(25, 'ALCL99 (NHL 2000 06)', 6),
	(26, 'ALCL99 Guidelines', 3),
	(27, 'Alemtuzumab (conditioning)', 3),
	(28, 'Alemtuzumab / AraC / Bulsulfan / Melphalan (conditioning)', 3),
	(29, 'Alendronate (Fosamax, Fosavance)', 23),
	(30, 'ALL UK 97: non-trial interim guidelines', 3),
	(31, 'ALL-R3', 6),
	(32, 'ALL-R3: Arm I', 6),
	(33, 'ALL-R3: non-trial interim guidelines', 3),
	(34, 'AMBIT: AC220', 6),
	(35, 'AMBIT: AraC (LD)', 6),
	(36, 'AMBIT: FLAG-Ida', 6),
	(37, 'AMBIT: MEC', 6),
	(38, 'AMG 531 Phase 2 trial', 6),
	(39, 'Amgen AMG 162: 12 weeks', 6),
	(40, 'Amgen AMG 162: 4 weeks', 6),
	(41, 'Amgen AMG 162: Bisphosphonates', 6),
	(42, 'Amgen: Denosumab', 6),
	(43, 'AML 14: AraC', 6),
	(44, 'AML 14: AraC / Mylotarg', 6),
	(45, 'AML 14: ICE', 6),
	(46, 'AML 14: intensive - D35 C200', 6),
	(47, 'AML 14: intensive - D35 C400', 6),
	(48, 'AML 14: intensive - D50 C200', 6),
	(49, 'AML 14: intensive - D50 C400', 6),
	(50, 'AML 14: MidAC', 6),
	(51, 'AML 15: ADE', 6),
	(52, 'AML 15: ADE / Lestaurtinib (CEP-701)', 6),
	(53, 'AML 15: ADE / Mylotarg', 6),
	(54, 'AML 15: APL - MRC protocol', 6),
	(55, 'AML 15: APL - Spanish protocol', 6),
	(56, 'AML 15: APL MRC Arm (MACE / Mylotarg)', 6),
	(57, 'AML 15: APL MRC Arm (MACE)', 6),
	(58, 'AML 15: APL MRC Arm (MidAC)', 6),
	(59, 'AML 15: APL MRC Arm ADE', 6),
	(60, 'AML 15: APL MRC Arm ADE / ATRA', 6),
	(61, 'AML 15: APL Spanish Arm (Ida / ATRA)', 6),
	(62, 'AML 15: APL Spanish Arm (Maintenance)', 6),
	(63, 'AML 15: APL Spanish Arm (Mitox / ATRA / Mylotarg)', 6),
	(64, 'AML 15: APL Spanish Arm (Mitox / ATRA)', 6),
	(65, 'AML 15: AraC', 6),
	(66, 'AML 15: AraC / Mylotarg', 6),
	(67, 'AML 15: DA', 6),
	(68, 'AML 15: DA / Mylotarg', 6),
	(69, 'AML 15: FLAG / Mylotarg', 6),
	(70, 'AML 15: FLAG-lda', 6),
	(71, 'AML 15: FLAG-lda / Mylotarg', 6),
	(72, 'AML 15: Ida / ATRA (consolidation)', 6),
	(73, 'AML 15: MACE', 6),
	(74, 'AML 15: MACE / Mylotarg', 6),
	(75, 'AML 15: MidAC', 6),
	(76, 'AML 15: Mitrox / ATRA (consolidation)', 6),
	(77, 'AML 15: Mitrox / ATRA / Mylotarg (consolidation)', 6),
	(78, 'AML 15: MTX / 6MP / ATRA (maintenance)', 6),
	(79, 'AML 16: intensive - AraC HD', 6),
	(80, 'AML 16: intensive - Azacytidine', 6),
	(81, 'AML 16: intensive - DA', 6),
	(82, 'AML 16: intensive - DA / Mylotarg', 6),
	(83, 'AML 16: intensive - DCLO', 6),
	(84, 'AML 16: intensive - DCLO / Mylotarg', 6),
	(85, 'AML 16: intensive - Mini Allograft', 6),
	(86, 'AML 16: intensive - non Mini-Allograft', 6),
	(87, 'AML 16: intensive ADE', 6),
	(88, 'AML 16: intensive ADE + ATRA', 6),
	(89, 'AML 16: intensive DA + ATRA', 6),
	(90, 'AML 16: no maintenance', 6),
	(91, 'AML 16: non-intensive', 6),
	(92, 'AML 16: non-intensive - AraC LD', 6),
	(93, 'AML 16: non-intensive - AraC LD / Mylotarg', 6),
	(94, 'AML 16: non-intensive - AraC LD / Zarnestra', 6),
	(95, 'AML 16: non-intensive - Clofarabine LD', 6),
	(96, 'AML 16: non-intensive - Sapacitabine', 6),
	(97, 'AML 16: non-intensive - Sapacitabine (LD)', 6),
	(98, 'AML 17: ADE', 6),
	(99, 'AML 17: ADE / Myelotarg - 3mg/mtr sqr', 6),
	(100, 'AML 17: ADE / Myelotarg - 6mg/mtr sqr', 6),
	(101, 'AML 17: AIDA', 6),
	(102, 'AML 17: AIDA (protocol)', 3),
	(103, 'AML 17: Allograft - reduced intensity', 6),
	(104, 'AML 17: Allograft - standard', 6),
	(105, 'AML 17: AraC consolidation - 1 course', 6),
	(106, 'AML 17: AraC consolidation - 2 courses', 6),
	(107, 'AML 17: AraC HD', 6),
	(108, 'AML 17: ATRA (protocol)', 3),
	(109, 'AML 17: ATRA + Arsenic trioxide', 6),
	(110, 'AML 17: ATRA + Arsenic trioxide (protocol)', 3),
	(111, 'AML 17: CEP-701', 6),
	(112, 'AML 17: DA - D 50mg', 6),
	(113, 'AML 17: DA - D 50mg / Gemtuzumab Ozogamicin (Mylotarg)', 6),
	(114, 'AML 17: DA - D 60mg', 6),
	(115, 'AML 17: DA - D 90mg', 6),
	(116, 'AML 17: DA - no further details', 6),
	(117, 'AML 17: DA / Mylotarg - 3mg/mtr sqr', 6),
	(118, 'AML 17: DA / Mylotarg - 6mg/mtr sqr', 6),
	(119, 'AML 17: Daunorubicin / Clofarabine', 6),
	(120, 'AML 17: DClo', 6),
	(121, 'AML 17: Everolimus (Afinitor)', 6),
	(122, 'AML 17: FLAG / IDA', 6),
	(123, 'AML 17: FLAG-Ida', 6),
	(124, 'AML 17: Ifosfamide (protocol)', 3),
	(125, 'AML 17: MACE', 6),
	(126, 'AML 17: MACE / MIDAC', 6),
	(127, 'AML 17: Pacritinib', 6),
	(128, 'AML 17: SCT (allogeneic)', 6),
	(129, 'AML 17: SCT (mini-allograft)', 6),
	(130, 'AML 18 Pilot: DA', 6),
	(131, 'AML 18 Pilot: DA / AC220', 6),
	(132, 'AML 18 Pilot: DAE / AC220', 6),
	(133, 'AML 18 Pilot: DAE/ Ganetespib', 6),
	(134, 'AML 18 Pilot: DCLO', 6),
	(135, 'AML 18 Pilot: DClo / Plerixafor', 6),
	(136, 'AML 18: AC220', 6),
	(137, 'AML 18: AC220 (maintenance)', 6),
	(138, 'AML 18: DA2+5 / AC220', 6),
	(139, 'AML 18: DA2+5 / Cladribine / AC220', 6),
	(140, 'AML 18: DA2+5 / Cladribine / Ganetespib', 6),
	(141, 'AML 18: DA2+5 / Cladribine no small molecule', 6),
	(142, 'AML 18: DA2+5 / Ganetespib', 6),
	(143, 'AML 18: DA2+5 no small molecule', 6),
	(144, 'AML 18: DA50 / AC220', 6),
	(145, 'AML 18: DA50 / Cladribine / AC220', 6),
	(146, 'AML 18: DA50 / Cladribine / Ganetespib', 6),
	(147, 'AML 18: DA50 / Cladribine no small molecule', 6),
	(148, 'AML 18: DA50 / Ganetespib', 6),
	(149, 'AML 18: DA50 no small molecule', 6),
	(150, 'AML 18: DA60 / 1 x Mylotarg', 6),
	(151, 'AML 18: DA60 / 2 x Mylotarg', 6),
	(152, 'AML 18: DA60 alone', 6),
	(153, 'AML 18: FLAG-Ida / AC220', 6),
	(154, 'AML 18: FLAG-Ida / Ganetespib', 6),
	(155, 'AML 18: FLAG-Ida no small molecule', 6),
	(156, 'AML 18: Ganetespib', 6),
	(157, 'AML 18: IDAC / AC220', 6),
	(158, 'AML 18: IDAC / Ganetespib', 6),
	(159, 'AML 18: IDAC no small molecule', 6),
	(160, 'AML 18: Mini FLAG-Ida / AC220', 6),
	(161, 'AML 18: Mini FLAG-Ida / Ganetespib', 6),
	(162, 'AML 18: Mini FLAG-Ida no small molecule', 6),
	(163, 'AML 18: no small molecule', 6),
	(164, 'AML 18: SCT (allograft)', 6),
	(165, 'AML 19: AIDA (Consolidation)', 6),
	(166, 'AML 19: AIDA (Induction)', 6),
	(167, 'AML 19: AraC (HD)', 6),
	(168, 'AML 19: AraC (IT)', 6),
	(169, 'AML 19: Busulfan / Fludarabine', 6),
	(170, 'AML 19: Busulfan / Fludarabine (conditioning)', 6),
	(171, 'AML 19: CPX-351', 6),
	(172, 'AML 19: Cyclophosphamide (conditioning)', 6),
	(173, 'AML 19: Cyclophosphamide / Busulfan (conditioning)', 6),
	(174, 'AML 19: DA / 1 x Mylotarg', 6),
	(175, 'AML 19: DA / 2 x Mylotarg', 6),
	(176, 'AML 19: DA alone', 6),
	(177, 'AML 19: FLAG-Ida / 1 x Mylotarg', 6),
	(178, 'AML 19: FLAG-Ida / 2 x Mylotarg', 6),
	(179, 'AML 19: FLAG-Ida alone', 6),
	(180, 'AML 19: Fludarabine / CPX-351', 6),
	(181, 'AML 19: MACE', 6),
	(182, 'AML 19: MidAC', 6),
	(183, 'AML 19: MRD monitoring arm', 6),
	(184, 'AML 19: No Consolidation', 6),
	(185, 'AML 19: No MRD monitoring', 6),
	(186, 'AML 19: Radiotherapy TBI (conditionaing)', 6),
	(187, 'AML 19: SCT (allograft)', 6),
	(188, 'AML 19: SCT (mini-allograft)', 6),
	(189, 'AML 19: SCT (reduced intensity)', 6),
	(190, 'AML Len5 (CTRU)', 6),
	(191, 'AML Len5: Lenalidomide', 6),
	(192, 'AML Len5: Lenalidomide / ADE', 6),
	(193, 'AML-HR: ADE', 6),
	(194, 'AML-HR: ADE / Atra', 6),
	(195, 'AML-HR: ADE / G-CSF', 6),
	(196, 'AML-HR: FLA', 6),
	(197, 'AML-HR: FLA / Atra', 6),
	(198, 'AML-HR: FLA / G-CSF', 6),
	(199, 'AMN 107 (CML)', 6),
	(200, 'Amsacrine', 3),
	(201, 'Anagrelide', 3),
	(202, 'Apheresis', 2),
	(203, 'AraC (HD)', 3),
	(204, 'Arac (HD) / Dexamethasone / Velcade / Rituximab', 3),
	(205, 'AraC (HD) / Methotrexate / Rituximab', 3),
	(206, 'AraC (HD) / Rituximab', 3),
	(207, 'AraC (HD) / Rituximab / Dexamethasone', 3),
	(208, 'AraC (IT)', 3),
	(209, 'AraC (LD)', 3),
	(210, 'AraC (LD) / Idarubicin', 3),
	(211, 'AraC (NOS)', 3),
	(212, 'AraC / Etoposide', 3),
	(213, 'AraC / Methotrexate', 3),
	(214, 'AraC HD  (priming)', 3),
	(215, 'ARCTIC (CTRU)', 6),
	(216, 'ARCTIC: FC / Rituximab', 6),
	(217, 'ARCTIC: FCM-miniR', 6),
	(218, 'Arsenic trioxide', 3),
	(219, 'Asparaginase', 3),
	(220, 'Aspirin', 3),
	(221, 'ATG', 3),
	(222, 'ATG / Bulsuphan / FLASMA (conditioning)', 3),
	(223, 'ATRA', 3),
	(224, 'AVD', 3),
	(225, 'Azacytidine', 3),
	(226, 'Azathioprine', 3),
	(227, 'AZD1152', 6),
	(228, 'BEACOPP', 3),
	(229, 'BEACOPP-e', 3),
	(230, 'BEAM', 3),
	(231, 'BEAM (conditioning)', 3),
	(232, 'BEAM (mini)', 3),
	(233, 'BEAM / Alemtuzumab', 3),
	(234, 'BEAM / Rituximab', 3),
	(235, 'Bendamustine', 3),
	(236, 'Bendamustine / Dexamethasone', 3),
	(237, 'Bendamustine / Prednisolone', 3),
	(238, 'Bendamustine / Rituximab', 3),
	(239, 'BEP', 3),
	(240, 'Bexarotene', 3),
	(241, 'BFORE (AV001): Bosutinib', 6),
	(242, 'BFORE (AV001): Imatinib', 6),
	(243, 'Bisphosphonates', 3),
	(244, 'BiTE: Blinatumomab', 6),
	(245, 'BLAST (NCRN170): Blinatumomab', 6),
	(246, 'Bleomycin', 3),
	(247, 'Blinatumomab', 3),
	(248, 'Blood products', 2),
	(249, 'BMD', 3),
	(250, 'BMT (allograft)', 17),
	(251, 'BMT (autograft)', 17),
	(252, 'BMT (mini-allograft)', 17),
	(253, 'Bortezomib', 3),
	(254, 'Bortezomib Study (mantle cell - phase II): CHOP / Bortezomib', 6),
	(255, 'Bortezomib Study (mantle cell - phase II): CHOP alone', 6),
	(256, 'Bosutinib (Bosulif)', 3),
	(257, 'Brentuximab (Adcetris)', 3),
	(258, 'BREVITY: Brentuximab', 6),
	(259, 'BTD', 3),
	(260, 'Budesonide', 9),
	(261, 'Busulfan', 3),
	(262, 'Busulfan (conditioning)', 3),
	(263, 'C-Thal-Dex (CTD)', 3),
	(264, 'C-Vel-P', 3),
	(265, 'C-weekly', 3),
	(266, 'C-Z-Dex', 3),
	(267, 'CALiBRe: Idelalisib', 6),
	(268, 'CAM203: Campath', 6),
	(269, 'CAM3 (mabCampath)', 6),
	(270, 'Campath', 3),
	(271, 'Campath / Dexamethasone', 3),
	(272, 'CAMPATH / Methylprednisolone', 3),
	(273, 'Campath / Prednisolone', 3),
	(274, 'Capecitabine', 3),
	(275, 'CDR', 3),
	(276, 'Celgene 009 (CLL 009)', 6),
	(277, 'Celgene MDS 005', 6),
	(278, 'CEOP', 3),
	(279, 'Ceplene/IL-2', 3),
	(280, 'CheckMate 205: Nivolumab', 6),
	(281, 'CheckMate 205: Nivolumab / doxorubicin / vinblastine / darcarbazine', 6),
	(282, 'Chelating agents', 2),
	(283, 'CHEMO-T: CHOP', 6),
	(284, 'CHEMO-T: GEM-P', 6),
	(285, 'Chlorambucil', 3),
	(286, 'Chlorambucil / Dexamethasone', 3),
	(287, 'Chlorambucil / Prednisolone', 3),
	(288, 'Chlorambucil / Rituximab', 3),
	(289, 'Chlorambucil / Rituximab Trial (Roche)', 6),
	(290, 'ChlVPP', 3),
	(291, 'ChlVPP / ABVD', 3),
	(292, 'ChlVPP / PABLOE', 3),
	(293, 'CHO', 3),
	(294, 'CHOP', 3),
	(295, 'CHOP / DHAP / Rituximab', 3),
	(296, 'CHOP / IFRT', 3),
	(297, 'CHOP / Rituximab', 3),
	(298, 'CHOP-Campath Trial (UKCRN)', 6),
	(299, 'CHOP-Maxi / AraC(HD)', 3),
	(300, 'CHOP-OR', 6),
	(301, 'CHOP-OR: Ofatumumab (maintenance)', 6),
	(302, 'CHOP-R-Maxi / AraC(HD)', 3),
	(303, 'Cisplatin', 3),
	(304, 'Cladrabine', 3),
	(305, 'Cladrabine / Rituximab', 3),
	(306, 'CLAEG', 3),
	(307, 'CLARITY: observation', 6),
	(308, 'CLASP', 3),
	(309, 'CLEAR', 6),
	(310, 'CLL-009: Lenalidomide', 6),
	(311, 'CLL11: Obinutuzumab / Chlorambucil', 6),
	(312, 'CLL210: Lenalidomide (maintenance)', 6),
	(313, 'CLL210: Ofatumumab, Dexamethasone, Lenalidomide', 6),
	(314, 'CLL4: Chlorambucil', 6),
	(315, 'CLL4: FC', 6),
	(316, 'CLL4: Fludarabine', 6),
	(317, 'CLL5: treated', 6),
	(318, 'CLL5: watch & wait', 6),
	(319, 'CLO + ETOP + CYC', 3),
	(320, 'Clodronate (Bonofos, Clasteon, Loron)', 23),
	(321, 'Clofarabine', 3),
	(322, 'Clofarabine / AraC', 3),
	(323, 'Clopidogrel', 3),
	(324, 'CM', 3),
	(325, 'CMD', 3),
	(326, 'CMML201 (CTRU)', 6),
	(327, 'CODOX-M', 3),
	(328, 'CODOX-M / IVAC', 3),
	(329, 'CODOX-M / IVAC-R', 3),
	(330, 'CODOX-M / Rituximab', 3),
	(331, 'Combined PS341 Trial', 6),
	(332, 'COMPLEMENT 1: Chlorambucil', 6),
	(333, 'Consolidation', 10),
	(334, 'CONTRALTO: Bendamustine / Rituximab', 6),
	(335, 'CONTRALTO: Venetoclax / Bendamustine / Rituximab', 6),
	(336, 'CONTRALTO: Venetoclax / Rituximab', 6),
	(337, 'COP', 3),
	(338, 'COP / COPADM', 3),
	(339, 'COP / Rituximab', 3),
	(340, 'COPAD', 3),
	(341, 'COPADM', 3),
	(342, 'COPADM2', 3),
	(343, 'COPDAC', 3),
	(344, 'COPP', 3),
	(345, 'CORAL: DHAP / Rituximab', 6),
	(346, 'CORAL: ICE / Rituximab', 6),
	(347, 'COSMIC: Bendamustine / Ofatumumab', 6),
	(348, 'COSMIC: Bendamustine / Ofatumumab (mega/HD)', 6),
	(349, 'COSMIC: FC / Ofatumumab', 6),
	(350, 'COSMIC: FC / Ofatumumab (mega/HD)', 6),
	(351, 'CT / Prednisolone', 3),
	(352, 'CTD attenuated (CTDa)', 3),
	(353, 'CVAD', 3),
	(354, 'CVP', 3),
	(355, 'CVP / Rituximab', 3),
	(356, 'CXD101', 6),
	(357, 'Cyclophosphamide', 3),
	(358, 'Cyclophosphamide (conditioning)', 3),
	(359, 'Cyclophosphamide (priming)', 3),
	(360, 'Cyclophosphamide / Campath (conditioning)', 3),
	(361, 'Cyclophosphamide / Dexamethasone', 3),
	(362, 'Cyclophosphamide / MESNA', 3),
	(363, 'Cyclophosphamide / Prednisolone', 3),
	(364, 'Cyclophosphamide / Thalidomide', 3),
	(365, 'Cyclosporin', 3),
	(366, 'Cyclosporin', 19),
	(367, 'CYM', 3),
	(368, 'Cytarabine (IT)', 3),
	(369, 'CYVE', 3),
	(370, 'CYVE / methotrexate', 3),
	(371, 'DA', 3),
	(372, 'DA / Myelotarg', 3),
	(373, 'Danazol', 3),
	(374, 'Danazol', 9),
	(375, 'Daratumumab expanded access program (MMY3010)', 6),
	(376, 'Dasatinib', 3),
	(377, 'DAT', 3),
	(378, 'Daunorubicin', 3),
	(379, 'DCLO', 3),
	(380, 'DEC - MDS', 6),
	(381, 'DECC', 3),
	(382, 'Denosumab (Xgeva)', 3),
	(383, 'Dexamethasone', 9),
	(384, 'DHAP', 3),
	(385, 'DHAP / Rituximab', 3),
	(386, 'DLC 001: Lenalidomide', 6),
	(387, 'Donor lymphocyte infusion', 2),
	(388, 'Doxyrubicin / Adriamycin', 3),
	(389, 'DRC', 3),
	(390, 'DT PACE', 3),
	(391, 'ELASTIC: Azacitidine (3 cycles)', 6),
	(392, 'ELASTIC: Azacitidine (6 cycles)', 6),
	(393, 'ELOQUENT-1: with Elotuzumab', 6),
	(394, 'ELOQUENT-1: without Elotuzumab', 6),
	(395, 'ELOQUENT-2: with Elotuzumab', 6),
	(396, 'ELOQUENT-2: without Elotuzumab', 6),
	(397, 'Eltrombopag', 3),
	(398, 'ENACT: Nilotinib', 6),
	(399, 'ENRICH: Bendamustine / Rituximab', 6),
	(400, 'ENRICH: CHOP / Rituximab', 6),
	(401, 'ENRICH: Ibrutinib (maintenance)', 6),
	(402, 'ENRICH: Ibrutinib / Rituximab', 6),
	(403, 'ENRICH: Rituximab (maintenance)', 6),
	(404, 'EORTC 20981: CHOP', 6),
	(405, 'EORTC 20981: CHOP / Rituximab', 6),
	(406, 'EPIC: Ponatinib', 6),
	(407, 'ESHAP', 3),
	(408, 'ESHAP / R', 3),
	(409, 'EsPhALL (UKALL2003) [Arm not recorded]', 6),
	(410, 'EsPhALL: with Imatinib', 6),
	(411, 'EsPhALL: with Imatinib (protocol)', 3),
	(412, 'EsPhALL: without Imatinib', 6),
	(413, 'Etamsylate', 2),
	(414, 'ETI', 3),
	(415, 'Etidronate (Didronel)', 23),
	(416, 'Etoposide', 3),
	(417, 'Etoposide (conditioning)', 3),
	(418, 'Etoposide / Rituximab', 3),
	(419, 'Etoposide / Rituximab / Dexamethasone', 3),
	(420, 'EuLITE', 6),
	(421, 'EURO-LB 02', 3),
	(422, 'EURO-LB 02', 6),
	(423, 'EURO-LB 02 Induction 1a', 3),
	(424, 'EURO-LB 02 Induction 1b', 3),
	(425, 'EURO-LB 02 Maintenance', 3),
	(426, 'EURO-LB 02 Protocol M', 3),
	(427, 'EURO-LB 02 Re-induction 2a', 3),
	(428, 'EURO-LB 02 Re-induction 2b', 3),
	(429, 'EuroNet-PHL-C1 (Hodgkin)', 3),
	(430, 'EuroNet-PHL-C1 (Hodgkin)', 6),
	(431, 'EuroNet-PHL-C1 (Hodgkins) relapse: BEAM', 6),
	(432, 'EuroNet-PHL-C1 (Hodgkins) relapse: IEP/ABVD', 6),
	(433, 'EuroNet-PHL-C1 (Hodgkins) relapse: Radiotherapy', 6),
	(434, 'EuroNet-PHL-C1 (Hodgkins) relapse: SCT', 6),
	(435, 'EuroNet-PHL-C1 (Hodgkins): OEPA', 6),
	(436, 'EuroNet-PHL-C1 (Hodgkins): OEPA/COP DAC', 6),
	(437, 'EuroNet-PHL-C1 (Hodgkins): OEPA/COPP', 6),
	(438, 'EuroNet-PHL-C1 (Hodgkins): Radiotherapy', 6),
	(439, 'European MCL network: R-CHOP / R-DHAP', 6),
	(440, 'Extracorporeal photopheresis (ECP)', 2),
	(441, 'F-CLL', 6),
	(442, 'FAB LMB 96', 3),
	(443, 'FAB LMB96', 6),
	(444, 'FC', 3),
	(445, 'FC (conditioning)', 3),
	(446, 'FC / ATG (conditioning)', 3),
	(447, 'FC / Campath (conditioning)', 3),
	(448, 'FC / Rituximab', 3),
	(449, 'FIGARO: FB-ATG (conditioning)', 6),
	(450, 'FIGARO: FBA (conditioning)', 6),
	(451, 'FIGARO: FLAMSA-BU', 6),
	(452, 'FIGARO: FMA (conditioning)', 6),
	(453, 'FIRST (MM-020 - Celgene): Arm A', 6),
	(454, 'FIRST (MM-020 - Celgene): Arm B', 6),
	(455, 'FIRST (MM-020 - Celgene): Arm C', 6),
	(456, 'FLA', 3),
	(457, 'FLA / G-CSF (FLAG)', 3),
	(458, 'FLA-Ida', 3),
	(459, 'FLAG', 3),
	(460, 'FLAG / Mylotarg', 3),
	(461, 'FLAG-lda', 3),
	(462, 'FLAG-lda / Myelotarg', 3),
	(463, 'FLAIR: FCR', 6),
	(464, 'FLAIR: Ibrutinib (maintenance)', 6),
	(465, 'FLAIR: Ibrutinib / Rituximab', 6),
	(466, 'FLAMSA', 3),
	(467, 'FLAMSA-BU', 3),
	(468, 'Flu / Bu / Campath', 3),
	(469, 'Flu/Bu/ATG', 3),
	(470, 'FluDAP', 3),
	(471, 'Fludarabine', 3),
	(472, 'Fludarabine (conditioning)', 3),
	(473, 'Fludarabine / Bulsuphan (conditioning)', 3),
	(474, 'Fludarabine / cyclophosphamide / alemtuzumab / methylprednisolone (conditioning)', 3),
	(475, 'Fludarabine / cyclophosphamide / LD-TBI (conditioning)', 3),
	(476, 'Fludarabine / cyclophosphamide / TBI (full intensity conditioning)', 3),
	(477, 'Fludarabine / Melphalan / Campath (conditioning)', 3),
	(478, 'Fludrocortisone', 9),
	(479, 'FMD', 3),
	(480, 'FMD / Rituximab', 3),
	(481, 'FORT (CRUK)', 6),
	(482, 'FRALLE-93: Induction (protocol)', 3),
	(483, 'G-CSF', 2),
	(484, 'G-CSF (priming)', 2),
	(485, 'GALACTIC: Obinutuzumab', 6),
	(486, 'GALACTIC: Observation', 6),
	(487, 'Galiximab', 6),
	(488, 'GALLIUM: CVP / Obinutuzumab (GA101)', 6),
	(489, 'GALLIUM: CVP / Rituximab', 6),
	(490, 'GALLIUM: Obinutuzumab (GA101) (maintenance)', 6),
	(491, 'GALLIUM: Rituximab (maintenance)', 6),
	(492, 'GCM-P', 3),
	(493, 'GCM-P / Rituximab', 3),
	(494, 'GCVP', 3),
	(495, 'GCVP / Rituximab', 3),
	(496, 'GEM-P', 3),
	(497, 'GEM-P (GCM-P)', 3),
	(498, 'GEM-P / Rituximab', 3),
	(499, 'GemBex (CRUK)', 6),
	(500, 'Gemcitabine', 3),
	(501, 'Gemcitabine / Cisplatin', 3),
	(502, 'Gemcitabine / Cisplatin / Methylprednisolone', 3),
	(503, 'Gemcitabine / Cisplatin / Prednisolone', 3),
	(504, 'Gemcitabine / Dexamethasone', 3),
	(505, 'Gemcitabine / Prednisolone', 3),
	(506, 'Gemcitabine / Prednisolone / Rituximab / Carboplatin', 3),
	(507, 'Gemcitabine / Rituximab', 3),
	(508, 'GEMOX-R', 3),
	(509, 'GEN406: Ofatumumab', 6),
	(510, 'GEN415: Ofatumumab', 6),
	(511, 'GEN416: Ofatumumab', 6),
	(512, 'Genetech: Obinutuzumab / venetoclax (GDC 0199)', 6),
	(513, 'Genetech: Obinutuzumab / venetoclax (GDC 0199) (maintenance)', 6),
	(514, 'Genmab BIFROST (CLL)', 6),
	(515, 'Genzyme ATG', 6),
	(516, 'Gilead 0115: Bendamustine / Rituximab', 6),
	(517, 'Gilead 0115: Bendamustine / Rituximab / Idelalisib', 6),
	(518, 'Gilead 0115: Idelalisib (maintenance)', 6),
	(519, 'Gilead 0115: Placebo (maintenance)', 6),
	(520, 'Gilead 0119: Ofatumumab', 6),
	(521, 'Gilead 0119: Ofatumumab / Idelalisib', 6),
	(522, 'Gilead 116: Idelalisib / Rituximab', 6),
	(523, 'Gilead 116: Rituximab', 6),
	(524, 'Gilead 117: Idelalisib', 6),
	(525, 'Gilead 125: Bendamustine / Rituximab', 6),
	(526, 'Gilead 125: Idelalisib (maintenance)', 6),
	(527, 'Gilead 125: Placebo (maintenance)', 6),
	(528, 'Gilead 125: Rituximab / Bendamustine / Idelalisib', 6),
	(529, 'Gilead 125: Rituximab / Bendamustine / Placebo', 6),
	(530, 'Gilead 133: Idelalisib / Rituximab', 6),
	(531, 'Granulocyte infusion', 2),
	(532, 'Haemodialysis', 2),
	(533, 'HAM', 3),
	(534, 'HD 200 02 (Hodgkins): ABVD / ChlVPP', 6),
	(535, 'HD 2000 02 (Hodgkin)', 6),
	(536, 'HD-MTX in PCNSL (CRUK)', 6),
	(537, 'HOVON 29 AML', 6),
	(538, 'Hydrocortisone', 9),
	(539, 'Hydroxymethylprednisolone', 3),
	(540, 'Hydroxyurea', 3),
	(541, 'Hydroxyurea / Aspirin', 3),
	(542, 'Hydroxyurea / Clopidogrel', 3),
	(543, 'HyperCVAD', 3),
	(544, 'HyperCVAD / MAG / Rituximab', 3),
	(545, 'HyperCVAD / Rituximab', 3),
	(546, 'Ibandronate (Boniva, Bondronat, Bonviva)', 23),
	(547, 'Ibrutinib (Imbruvica)', 3),
	(548, 'Ibrutinib (maintenance)', 3),
	(549, 'Ibrutinib / Dexamethasone', 3),
	(550, 'Ibrutinib / Rituximab', 3),
	(551, 'ICE', 3),
	(552, 'ICE / Rituximab', 3),
	(553, 'IciCLLe: Ibrutinib', 6),
	(554, 'ICiCLLe: Ibrutinib / obinutuzumab', 6),
	(555, 'IDARAM', 3),
	(556, 'IDARAM Trial', 6),
	(557, 'Idarubicin', 3),
	(558, 'Idelalisib (maintenance)', 3),
	(559, 'Idelalisib (Zydelig)', 3),
	(560, 'Idelalisib / Rituximab', 3),
	(561, 'IELSG19/MALT: Chlorambucil', 6),
	(562, 'IELSG19/MALT: Chlorambucil / Rituximab', 6),
	(563, 'IEP/ABVD', 3),
	(564, 'IFN-a', 3),
	(565, 'IFN-a (eye drops)', 3),
	(566, 'IFN-a / Ara-C', 3),
	(567, 'Ifosfamide / Autograft', 3),
	(568, 'Ifosfamide / Mitoxantrone', 3),
	(569, 'Imatinib', 3),
	(570, 'Immunoglobulins', 2),
	(571, 'INCA: GemRCVP', 6),
	(572, 'INCA: IORCVP', 6),
	(573, 'Infant ALL interim guidelines', 3),
	(574, 'Infinity: Duvelisib', 6),
	(575, 'Infinity: Duvesilib / Obinutuzumab', 6),
	(576, 'Infinity: Duvesilib / Obinutuzumab (maintenance)', 6),
	(577, 'Infinity: Duvesilib / Rituximab', 6),
	(578, 'Infinity: Duvesilib / Rituximab (maintenance)', 6),
	(579, 'Infinity: Ofatumumab ', 6),
	(580, 'INNOVATE: Arm A - Inotuzumab', 6),
	(581, 'INNOVATE: Arm B - AraC / Mitoxantrone', 6),
	(582, 'INNOVATE: Arm B - FLAG', 6),
	(583, 'INNOVATE: Arm B - HIDAC', 6),
	(584, 'INO-VATE: Inotuzumab', 6),
	(585, 'Inter-B-NHL Ritux 2010: Group B (COP)', 6),
	(586, 'Inter-B-NHL Ritux 2010: Group B (COPADM)', 6),
	(587, 'Inter-B-NHL Ritux 2010: Group B (COPADM-R)', 6),
	(588, 'Inter-B-NHL Ritux 2010: Group B (CYM)', 6),
	(589, 'Inter-B-NHL Ritux 2010: Group B (CYM-R)', 6),
	(590, 'Inter-B-NHL Ritux 2010: Group C1 (COP)', 6),
	(591, 'Inter-B-NHL Ritux 2010: Group C1 (COPADM)', 6),
	(592, 'Inter-B-NHL Ritux 2010: Group C1 (COPADM-R)', 6),
	(593, 'Inter-B-NHL Ritux 2010: Group C1 (CYVE CNS+ve)', 6),
	(594, 'Inter-B-NHL Ritux 2010: Group C1 (CYVE CNS-ve)', 6),
	(595, 'Inter-B-NHL Ritux 2010: Group C1 (CYVE-R CNS+ve)', 6),
	(596, 'Inter-B-NHL Ritux 2010: Group C1 (CYVE-R CNS-ve)', 6),
	(597, 'Inter-B-NHL Ritux 2010: Group C1 (M1)', 6),
	(598, 'Inter-B-NHL Ritux 2010: Group C1 (M2)', 6),
	(599, 'Inter-B-NHL Ritux 2010: Group C3 (COP)', 6),
	(600, 'Inter-B-NHL Ritux 2010: Group C3 (COPADM)', 6),
	(601, 'Inter-B-NHL Ritux 2010: Group C3 (COPADM-R)', 6),
	(602, 'Inter-B-NHL Ritux 2010: Group C3 (IT-CYVE)', 6),
	(603, 'Inter-B-NHL Ritux 2010: Group C3 (IT-CYVE-MTX)', 6),
	(604, 'Inter-B-NHL Ritux 2010: Group C3 (M1)', 6),
	(605, 'Inter-B-NHL Ritux 2010: Group C3 (M2)', 3),
	(606, 'Inter-B-NHL Ritux 2010: Group C3 (M2)', 6),
	(607, 'Inter-B-NHL Ritux 2010: Group C3 (R-IT-CYVE)', 6),
	(608, 'Inter-B-NHL Ritux 2010: Group C3 (R-IT-CYVE-MTX)', 6),
	(609, 'INTERFANT 06', 6),
	(610, 'INTERFANT 06 protocol', 3),
	(611, 'INTERFANT 06: ADE', 6),
	(612, 'INTERFANT 06: Allograft', 6),
	(613, 'INTERFANT 06: Experimental arm', 6),
	(614, 'INTERFANT 06: Induction', 6),
	(615, 'INTERFANT 06: MAE', 6),
	(616, 'INTERFANT 06: Maintenance', 6),
	(617, 'INTERFANT 06: MARMA', 6),
	(618, 'INTERFANT 06: OCTADA', 6),
	(619, 'INTERFANT 06: OCTADAD', 6),
	(620, 'INTERFANT 06: Protocol IB', 6),
	(621, 'INTERFANT 06: SCT', 6),
	(622, 'INTERFANT 06: Standard arm', 6),
	(623, 'INTERFANT 99', 6),
	(624, 'IPI-145 / Bendamustine / Rituximab', 6),
	(625, 'IPI-145 / Rituximab', 6),
	(626, 'Iron', 2),
	(627, 'ITCL (high dose)', 6),
	(628, 'IVAC', 3),
	(629, 'IVAC / Rituximab', 3),
	(630, 'IVE', 3),
	(631, 'IVE / Rituximab', 3),
	(632, 'JAKARTA', 6),
	(633, 'KHK2823', 6),
	(634, 'KW-2478: KW-2478 / Bortezomib', 6),
	(635, 'LEAM', 3),
	(636, 'LEGEND: Lenalidomide (maintenance)', 6),
	(637, 'LEGEND: LR-GEM', 6),
	(638, 'LEGEND: R-GEM-P', 6),
	(639, 'LEGEND: RG-EMP', 6),
	(640, 'Lenalidomide', 3),
	(641, 'Lenalidomide (maintenance)', 3),
	(642, 'LenaRIC: Lenalidomide (maintenance)', 6),
	(643, 'Lestaurtinib(CEP 701)', 3),
	(644, 'LI-1: AraC (Cytarabine) / AC220', 6),
	(645, 'LI-1: AraC (Cytarabine) / Vosaroxin', 6),
	(646, 'LI-1: AraC (Cytarabine) alone', 6),
	(647, 'LI-1: Sapacitabine', 6),
	(648, 'LI-1: Vosaroxin alone', 6),
	(649, 'LUCID (Biogen)', 6),
	(650, 'LY05: FC', 6),
	(651, 'LY05: FC / Rituximab', 6),
	(652, 'LY10: high risk - CODOX-M / IVAC', 6),
	(653, 'LY10: low risk - CODOX-M', 6),
	(654, 'LY10: untreated', 6),
	(655, 'LYM-1: maintenance only', 6),
	(656, 'LYM-1: no purge / maintenance', 6),
	(657, 'LYM-1: purging / maintenance', 6),
	(658, 'LYM-1: purging only', 6),
	(659, 'MaBLe: Bendamustine / Rituximab', 6),
	(660, 'MaBLe: Chlorambucil / Rituximab', 6),
	(661, 'MAC UCBT: Busulfan / Cyclophosphamide / Melphalan (conditioning)', 6),
	(662, 'MAC UCBT: Fludarabine / Cyclophosphamide (conditioning)', 6),
	(663, 'MAC UCBT: Radiotherapy (TBI)', 6),
	(664, 'MAC UCBT: Umbilical cord transplant', 6),
	(665, 'MACE', 3),
	(666, 'MAG', 3),
	(667, 'MAG-R', 3),
	(668, 'MAIA: Daratumumab / Lenalidomide / Dexamethasone', 6),
	(669, 'MAIA: Lenalidomide / Dexamethasone', 6),
	(670, 'MAJIC: Busulfan / Hydroxyurea / Anagrelide', 6),
	(671, 'MAJIC: clinician choice (Anagrelide)', 6),
	(672, 'MAJIC: clinician choice (Busulfan)', 6),
	(673, 'MAJIC: clinician choice (Hydroxyurea)', 6),
	(674, 'MAJIC: Ruxolitinib', 6),
	(675, 'Mantle Cell P3: FC', 6),
	(676, 'Mantle Cell P3: FCR', 6),
	(677, 'MARALL: Veltuzumab / Epratuzumab', 6),
	(678, 'MATRIX', 3),
	(679, 'MCOP', 3),
	(680, 'MCOP / Rituximab', 3),
	(681, 'MDM2 Inhibitor', 3),
	(682, 'MDS-Bio1 ', 6),
	(683, 'MDT', 3),
	(684, 'Mel-Dex', 3),
	(685, 'Melphalan', 3),
	(686, 'Melphalan (conditioning)', 3),
	(687, 'Melphalan / Prednisolone', 3),
	(688, 'Mercaptopurine', 3),
	(689, 'Mercaptopurine / Methotrexate', 3),
	(690, 'MERIT (NCRI)', 6),
	(691, 'Methotrexate', 3),
	(692, 'Methotrexate (HD prophylaxis)', 3),
	(693, 'Methotrexate (HD)', 3),
	(694, 'Methotrexate (IT prophylaxis)', 3),
	(695, 'Methotrexate (IT)', 3),
	(696, 'Methotrexate (prophylaxis)', 3),
	(697, 'Methotrexate + Cytarabine', 3),
	(698, 'Methotrexate / AraC / Hydrocortisone (IT)', 3),
	(699, 'Methylprednisolone', 9),
	(700, 'MidAC', 3),
	(701, 'Millennium: Ixazomib Citrate (maintenance)', 6),
	(702, 'Mini-BEAM', 3),
	(703, 'Mini-MIDAC', 3),
	(704, 'Mitoxantrone', 3),
	(705, 'MPT', 3),
	(706, 'MRC UKALL 2003 (regimen A)', 3),
	(707, 'MRC UKALL 2003 (regimen B)', 3),
	(708, 'MRC UKALL 2003 (regimen C)', 3),
	(709, 'MUD peripheral', 17),
	(710, 'MUK 5: CCD', 6),
	(711, 'MUK 5: CVD', 6),
	(712, 'MUK 5: no maintenance', 6),
	(713, 'MUK One', 6),
	(714, 'Mycophenolate', 19),
	(715, 'Myeloma IX: CTDa', 6),
	(716, 'Myeloma IX: intensive - CTD', 6),
	(717, 'Myeloma IX: intensive - CVAD', 6),
	(718, 'Myeloma IX: MP', 6),
	(719, 'Myeloma IX: Observation', 6),
	(720, 'Myeloma IX: Thalidomide', 6),
	(721, 'Myeloma X: Cyclosphosphamide', 6),
	(722, 'Myeloma X: HD Melphalan / ASCT', 6),
	(723, 'Myeloma X: PAD', 6),
	(724, 'Myeloma XI: intensive - ASCT', 6),
	(725, 'Myeloma XI: intensive - CCRD', 6),
	(726, 'Myeloma XI: intensive - CTD', 6),
	(727, 'Myeloma XI: intensive - HD Melphalan', 6),
	(728, 'Myeloma XI: intensive - no chemo', 6),
	(729, 'Myeloma XI: intensive - no maintenance', 6),
	(730, 'Myeloma XI: intensive - RCD', 6),
	(731, 'Myeloma XI: intensive - Revlimid / Vorinostat maintenance', 6),
	(732, 'Myeloma XI: intensive - Revlimid maintenance', 6),
	(733, 'Myeloma XI: intensive - VCD', 6),
	(734, 'Myeloma XI: non-intensive - CTDa', 6),
	(735, 'Myeloma XI: non-intensive - no chemo', 6),
	(736, 'Myeloma XI: non-intensive - no maintenance', 6),
	(737, 'Myeloma XI: non-intensive - RCDa', 6),
	(738, 'Myeloma XI: non-intensive - Revlimid / Vorinostat maintenance', 6),
	(739, 'Myeloma XI: non-intensive - Revlimid maintenance', 6),
	(740, 'Myeloma XI: non-intensive - VCD', 6),
	(741, 'Mylotarg', 3),
	(742, 'National Cord Blood Study (RIC): Radiotherapy (TBI)', 6),
	(743, 'National Cord Blood Study (RIC): Stem cell transplant (allogeneic)', 6),
	(744, 'National Cord Blood Study (RK): Cyclophosphamide / Fludarabine (conditioning)', 6),
	(745, 'NCI - Galiximab', 6),
	(746, 'NCRI CHOP/Velcade (Mantle Cell) [Arm not recorded]', 6),
	(747, 'NCRI FL: CMD', 6),
	(748, 'NCRI FL: FMD', 6),
	(749, 'NCRI Hodgkin (Stanford V)', 6),
	(750, 'NCRI Hodkgin (ABVD)', 6),
	(751, 'NCRI Mantle Cell Phase III', 6),
	(752, 'NCRI PET (Hodgkin)', 6),
	(753, 'NCRI R-CODOX-M/IVAC', 6),
	(754, 'NCRI RATHL', 6),
	(755, 'NCRN-2993: Daratumumab / REV/DEX', 6),
	(756, 'NCRN-2993: REV/DEX', 6),
	(757, 'Nelarabine (Arranon, Atriance)', 3),
	(758, 'NHL Guidelines: Group A (COPAD)', 3),
	(759, 'NHL Guidelines: Group B (COP)', 3),
	(760, 'NHL Guidelines: Group B (COPADM)', 3),
	(761, 'NHL Guidelines: Group B (CYM)', 3),
	(762, 'NHL Guidelines: Group C (COP)', 3),
	(763, 'NHL Guidelines: Group C (COPADM)', 3),
	(764, 'NHL Guidelines: Group C (CYVE CNS+ve)', 3),
	(765, 'NHL Guidelines: Group C (CYVE CNS-ve)', 3),
	(766, 'NHL Guidelines: Group C (M2)', 3),
	(767, 'NHL Guidelines: Group C (M4)', 3),
	(768, 'NHL guidelines: Group C - COPADM', 3),
	(769, 'NHL guidelines: Group C - CYVE', 3),
	(770, 'NHL guidelines: Group C - M1', 3),
	(771, 'NHL guidelines: Group C - M2+M4', 3),
	(772, 'NHL guidelines: Group C - M3', 3),
	(773, 'Nilotinib', 3),
	(774, 'Novartis CAMN 2303', 6),
	(775, 'Obinutuzumab / Chlorambucil', 3),
	(776, 'Obinutuzumab / Chlorambucil / Methylprednisolone', 3),
	(777, 'OEPA', 3),
	(778, 'OEPA/COPP', 3),
	(779, 'Ofatumumab (Arzerra)', 3),
	(780, 'Ofatumumab / Chlorambucil', 3),
	(781, 'Ofatumumab Study (Mantle Cell Phase II)', 6),
	(782, 'OMB110913: FC', 6),
	(783, 'OMB110913: FC / Ofatumumab', 6),
	(784, 'OPPA', 3),
	(785, 'ORCHARRD: Ofatumumab / DHAP', 6),
	(786, 'ORCHARRD: Rituximab / DHAP', 6),
	(787, 'Orthopaedic stabilisation', 2),
	(788, 'P32', 10),
	(789, 'PACE', 3),
	(790, 'PACIFICO: CVP-R', 6),
	(791, 'PACIFICO: FC-R', 6),
	(792, 'PACIFICO: Rituximab Maintenance', 6),
	(793, 'PAD', 3),
	(794, 'PADIMAC: Autograft', 6),
	(795, 'PADIMAC: PAD', 6),
	(796, 'PAIReD: BEAM / Campath (conditioning)', 6),
	(797, 'Palifermin', 2),
	(798, 'Palliative', 10),
	(799, 'Pamidronate (Aredia, Pamimed)', 23),
	(800, 'Panobinostat', 3),
	(801, 'PCYC: Ibrutinib / Lenalidomide / Rituximab', 6),
	(802, 'PECC', 3),
	(803, 'Pentostatin', 3),
	(804, 'PET (Hodgkin): ABVD', 6),
	(805, 'PET (Hodgkin): no radiotherapy', 6),
	(806, 'PET (Hodgkin): Radiotherapy', 6),
	(807, 'Pixantrone', 3),
	(808, 'Plasma exchange', 2),
	(809, 'Plerixafor', 2),
	(810, 'Plerixafor', 3),
	(811, 'PMitCEBO', 3),
	(812, 'PmitCEBO / Rituximab', 3),
	(813, 'Pollux: Daratumumab / Lenalidomide / Dexamethasone', 6),
	(814, 'Pollux: Lenalidomide / Dexamethasone', 6),
	(815, 'Pomalidomide (Imnovid)', 3),
	(816, 'Pomalidomide / Dexamethasone', 3),
	(817, 'Ponatinib (Iclusig)', 3),
	(818, 'Prednisolone', 9),
	(819, 'ProT4: with donor lymphocyte infusion', 6),
	(820, 'ProT4: without donor lymphocyte infusion', 6),
	(821, 'PT-1: Aspirin / Anagrelide', 6),
	(822, 'PT-1: Aspirin / Hydroxycarbamide (Hydroxyurea)', 6),
	(823, 'PT-1: Aspirin only', 6),
	(824, 'PT1 [Arm not recorded]', 6),
	(825, 'PUVA', 4),
	(826, 'QuANTUM-R: Quizartinib (AC220)', 6),
	(827, 'QuANTUM-R: Salvage - FLAG-IDA', 6),
	(828, 'QuANTUM-R: Salvage - LoDAC', 6),
	(829, 'QuANTUM-R: Salvage - MEC', 6),
	(830, 'R-CHOP: 14', 6),
	(831, 'R-CHOP: 21', 6),
	(832, 'R-CODOX-M/IVAC Trial', 6),
	(833, 'R2W: BCR', 6),
	(834, 'R2W: FCR', 6),
	(835, 'RAPID (NCRI)', 6),
	(836, 'RAPID (NCRI): ABVD (1 cycle)', 6),
	(837, 'RAPID (NCRI): ABVD (3 cycles)', 6),
	(838, 'RAPID (NCRI): No further treatment', 6),
	(839, 'RAPID (NCRI): Radiotherapy', 6),
	(840, 'Rasburicase (Elitek, Fasturtec)', 2),
	(841, 'RATHL: ABVD', 6),
	(842, 'RATHL: AVD', 6),
	(843, 'RATHL: BEACOPP-14', 6),
	(844, 'RATHL: BEACOPP-escalated', 6),
	(845, 'RATHL: Radiation', 6),
	(846, 'RATHL: Salvage Therapy', 6),
	(847, 'RAvVA: 5Azacitidine / Vorinostat', 6),
	(848, 'RAvVA: 5Azacitidine alone', 6),
	(849, 'RAY: Ibrutinib', 6),
	(850, 'RAY: Temsirolimus', 6),
	(851, 'RCD', 3),
	(852, 'RCDa', 3),
	(853, 'Regimen B Consolidation BFM (protocol)', 3),
	(854, 'Relapsed AML 2001/01: L-DNR / FLAG', 6),
	(855, 'REMoDL-B: Methotrexate', 6),
	(856, 'REMoDL-B: R-CHOP', 6),
	(857, 'REMoDL-B: R-CHOP / Bortezomib', 6),
	(858, 'RESONATE-2: Chlorambucil', 6),
	(859, 'RESONATE-2: Ibrutinib', 6),
	(860, 'RESONATE: Ibrutinib', 6),
	(861, 'RESONATE: Ofatumumab', 6),
	(862, 'REV/DEX', 3),
	(863, 'RGCVP (CRUK)', 6),
	(864, 'RIALtO: Idelalisib or placebo', 6),
	(865, 'RIALtO: Ofatumumab / Bendamustine', 6),
	(866, 'RIALtO: Ofatumumab / Chlorambucil', 6),
	(867, 'RICAZA: Azacitidine', 6),
	(868, 'Risedronate (Actonel, Atelvia, Benet)', 23),
	(869, 'Rituximab', 3),
	(870, 'Rituximab (maintenance)', 3),
	(871, 'Rituximab / Prednisolone', 3),
	(872, 'RO5045337', 6),
	(873, 'ROBUST: Ruxolitinib', 6),
	(874, 'Roche M020927: Chlorambucil', 6),
	(875, 'Roche M020927: Chlorambucil / Rituximab', 6),
	(876, 'Roche MDM2: (Arm A) RO5045377 / Cytarabine', 6),
	(877, 'Roche MDM2: (Arm B) RO5045377 / Cytarabine', 6),
	(878, 'Romidepsin', 3),
	(879, 'Romiplostim (thrombopoeitin analogue)', 2),
	(880, 'Ruxolitinib', 3),
	(881, 'SADAL: Selinexor (HD)', 6),
	(882, 'SADAL: Selinexor (LD)', 6),
	(883, 'Sapacitabine', 3),
	(884, 'SCORAD III: Multiple Fractions', 6),
	(885, 'SCORAD III: Single Fraction', 6),
	(886, 'SDX-101', 6),
	(887, 'SHEILD', 6),
	(888, 'SHIELD: VEPEMB', 6),
	(889, 'Sirolimus / Idelalisib', 3),
	(890, 'SOPRA: Selinexor', 6),
	(891, 'Sorafenib (Nexavar)', 3),
	(892, 'Spanish APML protocol', 3),
	(893, 'Spanish Protocol (APML) High risk Consolidation (I)', 3),
	(894, 'Spanish Protocol (APML) High risk Consolidation (II)', 3),
	(895, 'Spanish Protocol (APML) High risk Consolidation (III)', 3),
	(896, 'Spanish Protocol (APML) High risk Induction', 3),
	(897, 'Spanish Protocol (APML) Maintenance', 3),
	(898, 'Spanish Protocol (APML) MRD+ Consolidation (III)', 3),
	(899, 'Spanish Protocol (APML) Standard risk Consolidation (I)', 3),
	(900, 'Spanish Protocol (APML) Standard risk Consolidation (II)', 3),
	(901, 'Spanish Protocol (APML) Standard risk Induction', 3),
	(902, 'SPIRIT II: Dasatinib 100', 6),
	(903, 'SPIRIT II: Dasatinib 100 (protocol)', 3),
	(904, 'SPIRIT II: Imatinib 400', 6),
	(905, 'SPIRIT II: Imatinib 400 (protocol)', 3),
	(906, 'SPIRIT II: Nilotinib (protocol)', 3),
	(907, 'SPIRIT: Imatinib / peg-IFN', 6),
	(908, 'SPIRIT: Imatinib 400', 6),
	(909, 'SPIRIT: Imatinib 800', 6),
	(910, 'Stanford V: ABVD', 6),
	(911, 'Stanford V: no radiotherapy', 6),
	(912, 'Stanford V: radiotherapy', 6),
	(913, 'Stanford V: Stanford V', 6),
	(914, 'STRATUS: Pomalidomide / Dexamethasone', 6),
	(915, 'Tacrolimus', 3),
	(916, 'Tacrolimus', 19),
	(917, 'TBI', 10),
	(918, 'TEAMM Study: Placebo / Antibiotics', 6),
	(919, 'Thalidomide', 3),
	(920, 'Thalidomide (maintenance)', 3),
	(921, 'Thalidomide / Dexamathasone', 3),
	(922, 'Thalidomide / Prednisolone', 3),
	(923, 'Thiotepa (conditioning)', 3),
	(924, 'TIDE', 3),
	(925, 'Topical steroids', 9),
	(926, 'TOPPS: Group A (with prophylaxis)', 6),
	(927, 'TOPPS: Group B (without prophylaxis)', 6),
	(928, 'Tosedostat', 3),
	(929, 'TOWER: AraC (HD) / Vincristine / Methotrexate (IT)', 6),
	(930, 'Tranexamic acid', 2),
	(931, 'Treosulphan (conditioning)', 3),
	(932, 'TSET', 3),
	(933, 'UK Haplo: Cyclophosphamide HD (conditioning)', 6),
	(934, 'UK Haplo: Donor lymphocyte infusion', 6),
	(935, 'UK Haplo: Fludarabine / cyclophosphamide (LD) / cyclophosphamide (HD) (conditioning)', 6),
	(936, 'UK Haplo: Radiotherapy TBI (conditioning)', 6),
	(937, 'UK Haplo: Stem cell transplant (allograft)', 6),
	(938, 'UKALL 10 schedule', 3),
	(939, 'UKALL 12 (NCRI)', 6),
	(940, 'UKALL 12 schedule', 3),
	(941, 'UKALL 12: AraC (priming)', 6),
	(942, 'UKALL 12: AraC IT', 6),
	(943, 'UKALL 12: AraC IT (protocol)', 3),
	(944, 'UKALL 12: Consolidation', 6),
	(945, 'UKALL 12: Consolidation (protocol)', 3),
	(946, 'UKALL 12: Cyclosporin', 6),
	(947, 'UKALL 12: Etoposide (conditioning)', 6),
	(948, 'UKALL 12: GCSF (priming)', 6),
	(949, 'UKALL 12: Imatinib maintenance', 6),
	(950, 'UKALL 12: Induction - phase 1', 6),
	(951, 'UKALL 12: Induction - phase 1 (protocol)', 3),
	(952, 'UKALL 12: Induction - phase 2 - with Imatinib', 6),
	(953, 'UKALL 12: Induction - phase 2 - with Imatinib (protocol)', 3),
	(954, 'UKALL 12: Induction - phase 2 - without Imatinib', 6),
	(955, 'UKALL 12: Induction - phase 2 - without Imatinib (protocol)', 3),
	(956, 'UKALL 12: Intensification', 6),
	(957, 'UKALL 12: Intensification (protocol)', 3),
	(958, 'UKALL 12: Maintenance', 6),
	(959, 'UKALL 12: Maintenance (protocol)', 3),
	(960, 'UKALL 12: Methotrexate IT', 6),
	(961, 'UKALL 12: Methotrexate IT (protocol)', 3),
	(962, 'UKALL 12: Methotrexate oral', 6),
	(963, 'UKALL 12: Mitoxantrone (priming)', 6),
	(964, 'UKALL 12: Radiotherapy', 6),
	(965, 'UKALL 12: Radiotherapy (protocol)', 3),
	(966, 'UKALL 12: Radiotherapy TBI (conditioning)', 6),
	(967, 'UKALL 12: Stem cell transplant (allograft)', 6),
	(968, 'UKALL 12: Stem cell transplant (autograft)', 6),
	(969, 'UKALL 14 (NCRI)', 6),
	(970, 'UKALL 14 (NCRI): Flu / Mel / Campath', 6),
	(971, 'UKALL 14 (NCRI): Sibling Allograft (SCT)', 6),
	(972, 'UKALL 14 schedule', 3),
	(973, 'UKALL 14: Alemtuzumab (conditioning)', 6),
	(974, 'UKALL 14: Consolidation Ph+', 6),
	(975, 'UKALL 14: Consolidation Ph-', 6),
	(976, 'UKALL 14: Consolidation Ph- (protocol)', 3),
	(977, 'UKALL 14: Cyclophosphamide (conditioning)', 6),
	(978, 'UKALL 14: Cyclosporin', 6),
	(979, 'UKALL 14: Etoposide (conditioning)', 6),
	(980, 'UKALL 14: Fludarabine (conditioning)', 6),
	(981, 'UKALL 14: Induction - phase 1 Ph+', 6),
	(982, 'UKALL 14: Induction - phase 1 Ph+ (protocol)', 3),
	(983, 'UKALL 14: Induction - phase 1 Ph-', 6),
	(984, 'UKALL 14: Induction - phase 1 Ph- (protocol)', 3),
	(985, 'UKALL 14: Induction - phase 2 Ph+', 6),
	(986, 'UKALL 14: Induction - phase 2 Ph+ (protocol)', 3),
	(987, 'UKALL 14: Induction - phase 2 Ph-', 6),
	(988, 'UKALL 14: Induction - phase 2 Ph- (protocol)', 3),
	(989, 'UKALL 14: Intensification Ph+', 6),
	(990, 'UKALL 14: Intensification Ph-', 6),
	(991, 'UKALL 14: Intensification Ph- (protocol)', 3),
	(992, 'UKALL 14: Maintenance Ph+', 6),
	(993, 'UKALL 14: Maintenance Ph+ (protocol)', 3),
	(994, 'UKALL 14: Maintenance Ph-', 6),
	(995, 'UKALL 14: Maintenance Ph- (protocol)', 3),
	(996, 'UKALL 14: Melphalan (conditioning)', 6),
	(997, 'UKALL 14: Methotrexate', 6),
	(998, 'UKALL 14: Methotrexate (protocol)', 3),
	(999, 'UKALL 14: Palfermin P1', 6),
	(1000, 'UKALL 14: Palfermin P2', 6),
	(1001, 'UKALL 14: Radiotherapy', 6),
	(1002, 'UKALL 14: Radiotherapy TBI (conditioning)', 6),
	(1003, 'UKALL 14: Rituximab', 6),
	(1004, 'UKALL 14: Stem cell transplant (allograft)', 6),
	(1005, 'UKALL 2003 Regimen A Consolidation (protocol)', 3),
	(1006, 'UKALL 2003 Regimen A Delayed Intensification (protocol)', 3),
	(1007, 'UKALL 2003 Regimen A Induction (protocol)', 3),
	(1008, 'UKALL 2003 Regimen A Interim Maintenance (protocol)', 3),
	(1009, 'UKALL 2003 Regimen A Maintenance (protocol)', 3),
	(1010, 'UKALL 2003 Regimen B Delayed Intensification (protocol)', 3),
	(1011, 'UKALL 2003 Regimen B Induction (protocol)', 3),
	(1012, 'UKALL 2003 Regimen B Interim Maintenance (protocol)', 3),
	(1013, 'UKALL 2003 Regimen B Maintenance (protocol)', 3),
	(1014, 'UKALL 2003 Regimen B Standard BFM Consolidation (protocol)', 3),
	(1015, 'UKALL 2003 Regimen C Augmented BFM Consolidation (protocol)', 3),
	(1016, 'UKALL 2003 Regimen C Capizzi Interim Maintenance', 6),
	(1017, 'UKALL 2003 Regimen C Capizzi Interim Maintenance (protocol)', 3),
	(1018, 'UKALL 2003 Regimen C Delayed Intensification (protocol)', 3),
	(1019, 'UKALL 2003 Regimen C Induction (protocol)', 3),
	(1020, 'UKALL 2003 Regimen C Maintenance (protocol)', 3),
	(1021, 'UKALL 2003: regimen A', 6),
	(1022, 'UKALL 2003: Regimen A (protocol)', 3),
	(1023, 'UKALL 2003: Regimen A Consolidation', 6),
	(1024, 'UKALL 2003: Regimen A Delayed Intensification (I)', 6),
	(1025, 'UKALL 2003: Regimen A Delayed Intensification (II)', 6),
	(1026, 'UKALL 2003: Regimen A Induction', 6),
	(1027, 'UKALL 2003: Regimen A Interim Maintenance', 6),
	(1028, 'UKALL 2003: Regimen A Maintenance', 6),
	(1029, 'UKALL 2003: regimen B', 6),
	(1030, 'UKALL 2003: Regimen B (protocol)', 3),
	(1031, 'UKALL 2003: Regimen B Capizzi Interim Maintenance', 6),
	(1032, 'UKALL 2003: Regimen B Delayed Intensification (I)', 6),
	(1033, 'UKALL 2003: Regimen B Delayed Intensification (II)', 6),
	(1034, 'UKALL 2003: Regimen B Induction', 6),
	(1035, 'UKALL 2003: Regimen B Interim Maintenance', 6),
	(1036, 'UKALL 2003: Regimen B Maintenance', 6),
	(1037, 'UKALL 2003: Regimen B Standard BFM Consolidation', 6),
	(1038, 'UKALL 2003: regimen C', 6),
	(1039, 'UKALL 2003: Regimen C (protocol)', 3),
	(1040, 'UKALL 2003: Regimen C Augmented BFM Consolidation', 6),
	(1041, 'UKALL 2003: Regimen C Capizzi Interim Maintenance', 6),
	(1042, 'UKALL 2003: Regimen C Delayed Intensification (I)', 6),
	(1043, 'UKALL 2003: Regimen C Delayed Intensification (II)', 6),
	(1044, 'UKALL 2003: Regimen C Induction', 6),
	(1045, 'UKALL 2003: Regimen C Maintenance', 6),
	(1046, 'UKALL 2011 Guidelines: Group A', 3),
	(1047, 'UKALL 2011 Guidelines: Group B', 3),
	(1048, 'UKALL 2011 Guidelines: Group C', 3),
	(1049, 'UKALL 2011 Regimen A Consolidation (protocol)', 3),
	(1050, 'UKALL 2011 Regimen A Delayed Intensification (protocol)', 3),
	(1051, 'UKALL 2011 Regimen A Induction (protocol)', 3),
	(1052, 'UKALL 2011 Regimen A Maintenance (protocol)', 3),
	(1053, 'UKALL 2011 Regimen A Standard Interim Maintenance (protocol)', 3),
	(1054, 'UKALL 2011 Regimen B Consolidation BFM (protocol)', 3),
	(1055, 'UKALL 2011 Regimen B Delayed Intensification (protocol)', 3),
	(1056, 'UKALL 2011 Regimen B Induction (protocol)', 3),
	(1057, 'UKALL 2011 Regimen B Maintenance (protocol)', 3),
	(1058, 'UKALL 2011 Regimen B Standard Interim Maintenance (protocol)', 3),
	(1059, 'UKALL 2011 Regimen C Consolidation Augmented BFM (protocol)', 3),
	(1060, 'UKALL 2011 Regimen C Delayed Intensification (protocol)', 3),
	(1061, 'UKALL 2011 Regimen C Induction (protocol)', 3),
	(1062, 'UKALL 2011 Regimen C Maintenance (protocol)', 3),
	(1063, 'UKALL 2011 Regimen C Standard Interim Maintenance (protocol)', 3),
	(1064, 'UKALL 2011: ', 6),
	(1065, 'UKALL 2011: regimen A', 6),
	(1066, 'UKALL 2011: regimen A - delayed intensification', 6),
	(1067, 'UKALL 2011: regimen A - HD Methotrexate', 6),
	(1068, 'UKALL 2011: regimen A - maintenance A1 (pulses + IT)', 6),
	(1069, 'UKALL 2011: regimen A - maintenance A2 (IT without pulses)', 6),
	(1070, 'UKALL 2011: regimen A - maintenance A3 (pulses without IT)', 6),
	(1071, 'UKALL 2011: regimen A - maintenance A4 (no pulses no IT)', 6),
	(1072, 'UKALL 2011: regimen A - standard interim maintenance', 6),
	(1073, 'UKALL 2011: regimen A consolidation', 6),
	(1074, 'UKALL 2011: regimen A induction - short Dexamethasone', 6),
	(1075, 'UKALL 2011: regimen A induction - standard Dexamethasone', 6),
	(1076, 'UKALL 2011: regimen B', 6),
	(1077, 'UKALL 2011: regimen B - delayed intensification', 6),
	(1078, 'UKALL 2011: regimen B - HD Methotrexate', 6),
	(1079, 'UKALL 2011: regimen B - maintenance B1 (pulses + IT)', 6),
	(1080, 'UKALL 2011: regimen B - maintenance B2 (IT without pulses)', 6),
	(1081, 'UKALL 2011: regimen B - maintenance B3 (pulses without IT)', 6),
	(1082, 'UKALL 2011: regimen B - maintenance B4 (no pulses no IT)', 6),
	(1083, 'UKALL 2011: regimen B - standard interim maintenance', 6),
	(1084, 'UKALL 2011: regimen B consolidation (Berlin Frankfurt Munich protocol)', 6),
	(1085, 'UKALL 2011: regimen B induction - short Dexamethasone', 6),
	(1086, 'UKALL 2011: regimen B induction - standard Dexamethasone', 6),
	(1087, 'UKALL 2011: regimen C', 6),
	(1088, 'UKALL 2011: regimen C - Capizzi interim maintenance', 6),
	(1089, 'UKALL 2011: regimen C - delayed intensification', 6),
	(1090, 'UKALL 2011: regimen C - HD Methotrexate + Asparaginase', 6),
	(1091, 'UKALL 2011: regimen C - maintenance C1 (pulses + IT)', 6),
	(1092, 'UKALL 2011: regimen C - maintenance C2 (IT without pulses)', 6),
	(1093, 'UKALL 2011: regimen C - maintenance C3 (pulses without IT)', 6),
	(1094, 'UKALL 2011: regimen C - maintenance C4 (no pulses no IT)', 6),
	(1095, 'UKALL 2011: regimen C consolidation (augmented Berlin Frankfurt Munich protocol)', 6),
	(1096, 'UKALL 2011: regimen C induction - short Dexamethasone', 6),
	(1097, 'UKALL 2011: regimen C induction - standard Dexamethasone', 6),
	(1098, 'UKALL 60+: regimen A - consolidation', 6),
	(1099, 'UKALL 60+: regimen A - maintenance', 6),
	(1100, 'UKALL 60+: regimen A - phase 1 induction', 6),
	(1101, 'UKALL 60+: regimen A - phase 2 induction', 6),
	(1102, 'UKALL 60+: regimen B - consolidation', 6),
	(1103, 'UKALL 60+: regimen B - intensification', 6),
	(1104, 'UKALL 60+: regimen B - maintenance', 6),
	(1105, 'UKALL 60+: regimen B - phase 1 induction', 6),
	(1106, 'UKALL 60+: regimen B - phase 2 induction', 6),
	(1107, 'UKALL 60+: regimen C - consolidation 1', 6),
	(1108, 'UKALL 60+: regimen C - consolidation 2', 6),
	(1109, 'UKALL 60+: regimen C - maintenance year 1', 6),
	(1110, 'UKALL 60+: regimen C - maintenance year 2', 6),
	(1111, 'UKALL 60+: regimen C - phase 1 induction', 6),
	(1112, 'UKALL 60+: regimen C - phase 2 induction', 6),
	(1113, 'UKALL 60+: regimen D - consolidation', 6),
	(1114, 'UKALL 60+: regimen D - maintenance', 6),
	(1115, 'UKALL 60+: regimen D - phase 1 induction', 6),
	(1116, 'UKALL 60+: regimen D - phase 2 induction', 6),
	(1117, 'UKALL 60+: regimen E - consolidation 1', 6),
	(1118, 'UKALL 60+: regimen E - consolidation 2', 6),
	(1119, 'UKALL 60+: regimen E - consolidation 3', 6),
	(1120, 'UKALL 60+: regimen E - intensification', 6),
	(1121, 'UKALL 60+: regimen E - maintenance', 6),
	(1122, 'UKALL 60+: regimen E - phase 1 induction', 6),
	(1123, 'UKALL 60+: regimen E - phase 2 induction', 6),
	(1124, 'UKALL60+', 3),
	(1125, 'UKALL60+', 6),
	(1126, 'UKCLL01 FCM/FCM-R [Arm not recorded]', 6),
	(1127, 'UKCLL02 CamFlud', 6),
	(1128, 'UKCLL06 CamPred', 6),
	(1129, 'UKCLL07 MRD', 6),
	(1130, 'Ursodeoxycholic acid', 19),
	(1131, 'UV B', 3),
	(1132, 'VAD', 3),
	(1133, 'VALOR: Vosaroxin / AraC vs Placebo / AraC (double blind trial)', 6),
	(1134, 'VAPEC-B / IFRT', 3),
	(1135, 'VCD', 3),
	(1136, 'VCD (Myeloma XI)', 3),
	(1137, 'VCD / Rituximab', 3),
	(1138, 'VCD / Thalidomide', 3),
	(1139, 'Velcade', 3),
	(1140, 'Velcade / Dexamethasone', 3),
	(1141, 'VEPEMB', 3),
	(1142, 'Vinblastine', 3),
	(1143, 'Vinblastine / Prednisolone', 3),
	(1144, 'Vincristine', 3),
	(1145, 'Vincristine / Dexamethasone', 3),
	(1146, 'Vincristine / Methylprednisolone', 3),
	(1147, 'Vincristine / Prednisolone', 3),
	(1148, 'VMP', 3),
	(1149, 'VP / Rituximab', 3),
	(1150, 'VR-CAP', 3),
	(1151, 'VTD', 3),
	(1152, 'Watch & Wait (NCRI): With Rituximab', 6),
	(1153, 'Watch & Wait (NCRI): Without Rituximab', 6),
	(1154, 'WM1: Chlorambucil', 6),
	(1155, 'WM1: Fludarabine', 6),
	(1156, 'Wyeth CML: Bosutinib', 6),
	(1157, 'Wyeth CML: Imatinib', 6),
	(1158, 'Z-DEX', 3),
	(1159, 'Zevalin', 3),
	(1160, 'Zevalin / Rituximab', 3),
	(1161, 'Zoledronate (Zometa, Zomera, Aclasta, Reclast)', 23),
	(1162, 'Zoster study', 6);
/*!40000 ALTER TABLE `treatment_details` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.treatment_types
CREATE TABLE IF NOT EXISTS `treatment_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.treatment_types: ~29 rows (approximately)
/*!40000 ALTER TABLE `treatment_types` DISABLE KEYS */;
INSERT INTO `treatment_types` (`id`, `description`) VALUES
	(1, 'observation'),
	(2, 'supportive care'),
	(3, 'chemotherapy'),
	(4, 'non-haematological'),
	(5, 'discharged to GP'),
	(6, 'clinical trial'),
	(7, 'venesection'),
	(8, 'resection'),
	(9, 'steroids'),
	(10, 'radiotherapy'),
	(11, 'palliative'),
	(12, 'H. pylori eradication'),
	(13, 'splenectomy'),
	(14, 'community monitoring'),
	(15, 'died pre-treatment'),
	(16, 'refused treatment'),
	(17, 'stem cell transplant'),
	(18, 'erythropoietin'),
	(19, 'immunosuppressive'),
	(20, 'vertebroplasty'),
	(21, 'combination'),
	(22, 'stem cell harvest'),
	(23, 'Bisphosphonates'),
	(24, 'Liverpool care pathway'),
	(25, 'Lost to hospital'),
	(26, 'discharged from haematology'),
	(27, 'telephone clinic'),
	(28, 'survivorship clinic'),
	(29, 'Care of dying pathway');
/*!40000 ALTER TABLE `treatment_types` ENABLE KEYS */;

-- Dumping data for table hmrn_test._menu_options: ~0 rows (approximately)
/*!40000 ALTER TABLE `_menu_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `_menu_options` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
