package LIMS::Model::Storage;

use Moose;
extends 'LIMS::Model::Base';
use namespace::clean -except => 'meta';
__PACKAGE__->meta->make_immutable;

use Data::Dumper;
use LIMS::Local::Utils;

#-------------------------------------------------------------------------------
sub input_storage {
    my ($self, $data) = @_; # warn Dumper $data;
    
    { # add specimen.id:
        my $o = LIMS::DB::Specimen::Manager->get_specimens();
        my %map = map { $_->sample_code => $_->id } @$o;
        
        my $specimen = $data->{specimen};
        $data->{specimen_id} = $map{$specimen};
    } # warn Dumper $data;

    my $vialID = $data->{vialId}; # 10 chars, or multiples of (input validated)

    if ( length $vialID > 10 ) { # have multiple vials
        my (@ids) = $vialID =~ /([A-Z]{2}\d{8})/g; # warn Dumper \@ids;
        for my $vial_id(@ids) { # warn $vial_id;
            my $c = LIMS::Local::Utils::clone($data);
            $c->{vialId} = $vial_id; # warn Dumper $c;
            
            my $rtn
                = $self->update_object({ class => 'RequestStorage', data => $c });
            return $rtn if $rtn; # only returns true on error
        }
        return 0;
    }
    else {
        return $self->update_object({ class => 'RequestStorage', data => $data });
    }  
}

#-------------------------------------------------------------------------------
sub output_storage {
    my ($self, $data) = @_; # warn Dumper $data;
    
    my $request_id = $data->{request_id};
    my $vial_id    = $data->{vialId};
    
    my $o = LIMS::DB::RequestStorage->new(vialId => $vial_id)->load_speculative
    || return { error => "vialId $vial_id does not exist" };
    
    # first check vialId belongs to request_id:
    unless ( $o->request_id eq $request_id ) {
        return { error => "vialId $vial_id does not belong to this request" }
    }
    
    $o->signed_out(LIMS::Local::Utils::time_now);
    $o->save(changes_only => 1);
    return 'OK';
}

#-------------------------------------------------------------------------------
sub update_storage {
    my ($self, $data) = @_; # warn Dumper $data;
    
    my $rtn = do {
        my %args = ( class => 'RequestStorage', data => $data );
        $self->update_object(\%args); # doesn't do 'changes_only'
    };
}

#-------------------------------------------------------------------------------
sub update_rack_id {
    my ($self, $data) = @_; # warn Dumper $data;
    
    my $i = LIMS::DB::RequestStorage::Manager->update_objects(
        set   => { rack_id => $data->{rack_id} },
        where => [ vialId  => $data->{vialId}  ],
    );
    return $i; # number of rows updated
}
    
#-------------------------------------------------------------------------------
sub get_request_storage {
    my ($self, $request_id) = @_;
    
    my @args = (
        query => [ request_id => $request_id ],
        with_objects => 'specimen',
    );
    my $o = LIMS::DB::RequestStorage::Manager->get_objects(@args);
    return $o;
}

#-------------------------------------------------------------------------------
sub get_storage_vial {
    my ($self, $vial_id) = @_;
    my $o = LIMS::DB::RequestStorage->new(vialId => $vial_id)->load;
    return $o;
}

#-------------------------------------------------------------------------------
sub get_storage_rack {
    my ($self, $plateId) = @_;
    
    my $o = LIMS::DB::StorageRack->new( plateId => $plateId )->load_speculative;
    return $o ? $o->as_tree : 0; # return hashref for use in session
}

#-------------------------------------------------------------------------------
sub new_storage_rack {
    my ($self, $plateId) = @_;
    # return id if exists, otherwise create new object first:
    my $o = LIMS::DB::StorageRack->new( plateId => $plateId )->load_or_insert;
    return $o->id;
}

#-------------------------------------------------------------------------------
sub get_rack_contents { # find rack contents by rack.id, or list of vialId's:
    my ($self, $args) = @_;
    
    my $query;
    if ( my $rack_id = $args->{rack_id} ) {
        $query = [ rack_id => $rack_id ];
    }
    elsif ( my $vial_ids = $args->{vial_ids} ) {
        $query = [ vialId => $vial_ids ];
    }
    my @args = ( query => $query );
    my $o = LIMS::DB::RequestStorage::Manager->get_objects(@args);
    return $o;
}

1;