package LIMS::DB::ParentOrganisation;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'parent_organisations',

    columns => [
        id               => { type => 'serial', not_null => 1 },
        parent_code      => { type => 'varchar', length => 6, not_null => 1 },
        description      => { type => 'varchar', length => 255, not_null => 1 },
        referral_type_id => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'description' ],
        [ 'parent_code' ],
    ],

    foreign_keys => [
        referral_type => {
            class       => 'LIMS::DB::ReferralType',
            key_columns => { referral_type_id => 'id' },
        },
    ],
    
    relationships => [
# do we still need these ?
#        hospital_departments => {
#            map_class => 'LIMS::DB::ReferrerDepartmentMap',
#            map_from  => 'parent_organisation',
#            map_to    => 'hospital_department',
#            type      => 'many to many',
#        },

        local_network => {
            class      => 'LIMS::DB::LocalNetworkLocation',
            column_map => { id => 'parent_id' },
            type       => 'one to many',
        },
        
        referral_source => {
            class      => 'LIMS::DB::ReferralSource',
            column_map => { id => 'parent_organisation_id' },
            type       => 'one to many',
        },

        referral_types => {
            map_class => 'LIMS::DB::ReferralSource',
            map_from  => 'parent_organisation',
            map_to    => 'referral_type',
            type      => 'many to many',
        },

        referrer_department => {
            class      => 'LIMS::DB::ReferrerDepartment',
            column_map => { id => 'parent_organisation_id' },
            type       => 'one to many',
        },
        # relationship for Model::Request::_build_referral_type_map()
        unknown_referrer_department => {
            class      => 'LIMS::DB::ReferrerDepartment',
            column_map => { id => 'parent_organisation_id' },
            type       => 'one to one', # only 1 unknown referral_source in p_o table
        },
        
        user_locations => {
            class      => 'LIMS::DB::UserLocation',
            column_map => { parent_code => 'region_code' },
            type       => 'one to many',
        },
    ],
);

#=cut

#__PACKAGE__->meta->table('organisation_map');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 4);

__PACKAGE__->meta->make_manager_class('parent_organisations');

1;
