package LIMS::Controller::Admin::Lab::Test::ResultOptions;

use base 'LIMS::Base';
use LIMS::Local::Sugar;

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

# -------------------------------------------------------------------------------------
startmode default ($errs) {
    $self->_debug_path($self->get_current_runmode);

	{ # lab test result options:
		my $lab_test_result_options
			= $self->model('LabTest')->get_lab_test_result_options;
		$self->tt_params( result_options => $lab_test_result_options );
	}
	{ # data type options
        my @args = ('LabTestResultDataType', { sort_by => 'description'} );
		my $data_types = $self->model('Base')->get_objects(@args);
        $self->tt_params( data_types => $data_types );		
	}
    
    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('lab_test_result_options');
    
    $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode edit ($errs, $id) {
	$self->_debug_path($self->get_current_runmode);
	
    $id || return $self->error('no id passed to '.$self->get_current_runmode); 

    { # data:
		my $data = $self->model('LabTest')->get_lab_test_result_option($id);
		$self->tt_params( data => $data	);
	}
	{ # data type options
        my @args = ('LabTestResultDataType', { sort_by => 'description'} );
		my $data_types = $self->model('Base')->get_objects(@args);
        $self->tt_params( data_types => $data_types );		
	}

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('lab_test_result_options');

    return $self->tt_process($errs);	
}

# -------------------------------------------------------------------------------------
runmode update ($id) {
    $self->_debug_path($self->get_current_runmode);

	# put id (if submitted) into params() as _record_id for validation:	
    if ( $id ) { 
        $self->query->param( _record_id => $id );
    }

	# if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('lab_test_result_options') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
    || return $self->forward('default'); # eg if empty param

	$data->{id} = $id;

    my $rtn = $self->model('LabTest')->update_lab_test_result_option($data);

    return $rtn ?
        $self->error($rtn) :
            $self->redirect( $self->query->url . '/admin/lab_test_result-options' );
}

1;