package LIMS::DB::Outreach::PracticeBloodTube;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',

    table   => 'practice_blood_tube',

    columns => [
        practice_id => { type => 'integer', not_null => 1 },
        tube_type   => { type => 'enum', check_in => [ 'vacutainer', 'monovette' ] },
        time        => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'practice_id' ],

    foreign_keys => [
        practice => {
            class       => 'LIMS::DB::ReferralSource',
            key_columns => { practice_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('practice_blood_tubes');

1;