package LIMS::Controller::Roles::User;

use Moose::Role;
use Data::Dumper;

has lab_staff => (
    is      => 'ro',
    isa 	=> 'ArrayRef[HashRef]',
    traits  => ['Array'],
    default => sub { [] },
	handles	=> {
        add_lab_staff_user => 'push',
    },
);

sub get_lab_staff_users {
    my $self = shift;

	my $all_users = $self->model('User')->get_all_users({sort_by => 'username'});
    my $settings  = $self->cfg('settings'); # warn Dumper $settings;

    my $lab_name_abbr = $settings->{lab_name_abbreviation}; # always exists
    my $central_labs  = $settings->{central_labs} || '';    # optional

    my @labs;
    push @labs, $lab_name_abbr;
    push @labs, split ',', $central_labs; # warn Dumper \@labs;

    for my $user (@$all_users) {
        my $user_location = $central_labs eq 'all_locations' # eg genomics, make all lab-staff:
            ? 'all_locations' : $user->user_location->location_name;
        next unless $user->active eq 'yes' && grep $user_location eq $_, @labs; # warn $user->username;

        my %user = (
            id => $user->id,
            username => $user->username,
        );

        $self->add_lab_staff_user(\%user);
    } # $self->debug($self->lab_staff);

    return $self->lab_staff;
}

#-------------------------------------------------------------------------------
sub generate_new_password {
    my $self = shift;

    srand;

	# assemble list of alphanumeric chars, excluding ambiguous lc(L), uc(o), 0 & 1:
	my @elements = grep m![^lO]!, ( 'a' .. 'z', 'A' .. 'Z', 2 .. 9 );

	# join 10 randomly-selected @elements:
	my $pwd = join '', ( map $elements[ int(rand @elements) ], 1 .. 10 );
	return $pwd;
}

1;
