package LIMS::Controller::Admin::Config::RequestAuditCategories;

use strict;
use warnings;

use base 'LIMS::Base';
use LIMS::Local::Sugar;

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

# ------------------------------------------------------------------------------
startmode default ($errs) { # $self->stash( errs => $errs );
    $self->_debug_path($self->get_current_runmode);

	my $audit_categories
        = $self->model('RequestAudit')->get_audit_categories;

    $self->tt_params(
        categories => $audit_categories,
	);

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('request_audit_categories');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode edit ($errs, $id) {
    $self->_debug_path($self->get_current_runmode);

    $id || return $self->error('no id passed to '.$self->get_current_runmode);  # $self->debug('id:'.$id);

    my $data = $self->model('RequestAudit')->get_request_audit_category($id);

    $self->tt_params( data => $data );

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('request_audit_categories');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode update ($id) {
    $self->_debug_path($self->get_current_runmode);

	# put id (if submitted) into params() as _record_id for validation:	
    if ( $id ) { 
        $self->query->param( _record_id => $id );
    }

    # if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('request_audit_categories') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
    || return $self->forward('default'); # eg if empty param

	# provide 'id' if supplied, so record updated, otherwise new one created: 
	if ($id) { $data->{id} = $id; }

    my $rtn = $self->model('RequestAudit')->update_request_audit_categories($data); 

    return $rtn ?
        $self->error($rtn) :
            $self->redirect( $self->query->url . '/config/request-audit-categories' );
}

1;