#!/usr/bin/env perl
use Modern::Perl;
use utf8;

use File::Spec::Functions qw( catdir );
use FindBin qw( $Bin );
use Test::Class::Moose::Load catdir( $Bin, 'lib' );
use Test::Class::Moose::Runner;

# expand/map ARGV classes to handle oddities like Trello=>Issuetracker
#  NotTestable => the 3 files in subdirectory NotTestable/Dev.pm etc

my @CLASSES;
my $difficult_cases = {
    'TestsFor::LIMS::Local::Role::NotTestable' => sub {
        map { push @CLASSES, "TestsFor::LIMS::Local::Role::NotTestable::$_" }
          qw/Dev Live LiveTest/;
    },
    'TestsFor::LIMS::Local::IssueTracker::Plugin::Trello' =>
      sub { push @CLASSES, 'TestsFor::LIMS::Local::IssueTracker'; },
};
foreach (@ARGV) {
    if ( exists $difficult_cases->{$_} ) {
        $difficult_cases->{$_}->();
    }
    else {
        push @CLASSES, $_;
    }
}

Test::Class::Moose::Runner->new( test_classes => \@CLASSES, )->runtests;

__END__

=pod

=encoding UTF-8

=for stopwords run.t
=head1 NAME

run.t - Test::Class::Moose runner

=head1 USAGE

prove -l t/run.t

prove -l t/run.t :: TestsFor::LIMS::Local::RfC

=head1 DESCRIPTION

run.t runs the unit tests in t/lib/TestsFor/

=head1 REQUIRED ARGUMENTS

None

=head1 OPTIONS

Optionally give a test class name preceeded by :: to guard it from prove

=head1 EXIT STATUS

=head1 CONFIGURATION

=head1 DEPENDENCIES

=head1 BUGS AND LIMITATIONS

Any odd cases have to be coded into the $difficult_cases hashref

This makes it possible to automate unit testing in a git hook

When a perl module is commited we can run run.t with the equiv test class name

run.t will fail if there is no unit test. This is no good for the majority of legacy code which has no tests

use ENV in hook to switch off this check

NO_UNIT_TESTS=1 git commit

=head1 AUTHOR

Garry Quested <garry.quested@nhs.net>

=head1 LICENSE AND COPYRIGHT

Copyright (c) 2018, HMDS.  All Rights Reserved.

This script is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

