package LIMS::DB::ICDOSubCategory;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'icdo_sub_category',

    columns => [
        diagnostic_category_id => { type => 'integer', not_null => 1 },
        icdo3                  => { type => 'varchar', length => 6, not_null => 1 },
    ],

    primary_key_columns => [ 'diagnostic_category_id', 'icdo3' ],

    foreign_keys => [
        diagnostic_category => {
            class       => 'LIMS::DB::DiagnosticCategory',
            key_columns => { diagnostic_category_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('icdo_sub_category');

1;
