package LIMS::DB::RequestAuthorisationDiagnosis;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'request_authorisation_diagnosis',

    columns => [
        request_id          => { type => 'integer', not_null => 1 },
        report_diagnosis_id => { type => 'integer', default => '0', not_null => 1 },
        auth_diagnosis_id   => { type => 'integer', default => '0', not_null => 1 },
        user_id             => { type => 'integer', default => '0', not_null => 1 },
        time                => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        auth_diagnosis => {
            class       => 'LIMS::DB::Diagnosis',
            key_columns => { auth_diagnosis_id => 'id' },
        },

        report_diagnosis => {
            class       => 'LIMS::DB::Diagnosis',
            key_columns => { report_diagnosis_id => 'id' },
        },

        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },

        user => {
            class       => 'LIMS::DB::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('request_authorisation_diagnoses');

1;