package LIMS::DB::Outreach::QuestionnaireSymptoms;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',
    
    table   => 'questionnaire_symptoms',
    
    columns => [
        request_id   => { type => 'integer', not_null => 1 },
        weight_loss  => {
            type     => 'enum',
            check_in => [ 'Y', 'N', 'U' ],
            default  => 'U',
            not_null => 1,
        },
        night_sweats => {
            type     => 'enum',
            check_in => [ 'none', 'occasional', 'frequent', 'drenching', 'unstated' ],
            default  => 'unstated',
            not_null => 1,
        },
        adenopathy => {
            type     => 'enum',
            check_in => [ 'none', 'stable', 'unstable', 'unstated' ],
            default  => 'unstated',
            not_null => 1,
        },
        pain => {
            type     => 'enum',
            check_in => [ 'none', 'stable', 'unstable', 'unstated' ],
            default  => 'unstated',
            not_null => 1,
        },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('questionnaire_symptoms');

1;
