package LIMS::DB::DeletedRequest;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup (
    table   => 'deleted_requests',

    columns => [
        id             => { type => 'serial', not_null => 1 },
        request_id     => { type => 'integer' },
        request_number => { type => 'integer' },
        year           => { type => 'scalar', default => '0000', length => 4, not_null => 1 },
        action         => { type => 'varchar', length => 255, not_null => 1 },
        user_id        => { type => 'integer', default => '0', not_null => 1 },
        time           => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        user => {
            class       => 'LIMS::DB::User',
            key_columns => { user_id => 'id' },
        },
    ],
);
#=cut

__PACKAGE__->meta->make_manager_class('deleted_requests');

1;
