package Role::Specimen;

use Moose::Role;
#requires qw(specimen_map);

sub do_specimens {
    my $self = shift;
    my $vals = shift;

    my $specimen_map = $self->specimen_map;

	# extract unique specimen codes:
    my @specimens = keys %{
        { map { $_ => 1 } split ', ', $vals->{specimen} }
    };

    SPECIMEN: foreach my $specimen(@specimens) { # warn $specimen;
        if ( my $specimen_id = $specimen_map->{$specimen} ) { # warn $specimen_id;
            my %data = (
                request_id  => $vals->{_request_id},
                specimen_id => $specimen_id,
            );
            $self->db->{dbix4}->insert('request_specimen', \%data);
        }
        else {
            print "no such sample_code: $specimen\n";
            next SPECIMEN;
        }
    }
}

1;
