package LIMS::DB::User;

use base qw(LIMS::RDBO);

# to allows now() to be passed to mySQL as a default value:
__PACKAGE__->meta->allow_inline_column_values(1); 

__PACKAGE__->meta->setup (
    table   => 'users',

    columns => [
        id               => { type => 'serial', not_null => 1 },
        username         => { type => 'varchar', length => 50, not_null => 1 },
        first_name       => { type => 'varchar', length => 50, not_null => 1 },
        last_name        => { type => 'varchar', length => 50, not_null => 1 },
        password         => { type => 'varchar', length => 32, not_null => 1 },
        email            => { type => 'varchar', length => 50, not_null => 1 },
        user_location_id => { type => 'integer', not_null => 1 },
        designation      => { type => 'varchar', length => 255, not_null => 1 },
        group_id         => { type => 'integer', not_null => 1 },
        last_login       => { type => 'datetime', not_null => 1, default => 'NOW()' },
        active           => { type => 'enum', check_in => [ 'yes', 'no' ],
                                default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'email' ], [ 'username' ], [ qw(first_name last_name) ],
    ],

    foreign_keys => [
        group => {
            class       => 'LIMS::DB::UserGroup',
            key_columns => { group_id => 'id' },
        },
        user_location => {
            class       => 'LIMS::DB::UserLocation',
            key_columns => { user_location_id => 'id' },
        },
    ],

    relationships => [
        deleted_requests => {
            class      => 'LIMS::DB::DeletedRequest',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },
        
        logins => {
            class      => 'LIMS::DB::Login',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        patient_edits => {
            class      => 'LIMS::DB::PatientEdit',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_authorisation_diagnosis => {
            class      => 'LIMS::DB::RequestAuthorisationDiagnosis',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_diagnosis_history => {
            class      => 'LIMS::DB::RequestDiagnosisHistory',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_history => {
            class      => 'LIMS::DB::RequestHistory',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_error_code => {
            class      => 'LIMS::DB::RequestErrorCode',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_lab_test_history => {
            class      => 'LIMS::DB::RequestLabTestHistory',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_lab_test_status => {
            class      => 'LIMS::DB::RequestLabTestStatus',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_phone_log => {
            class      => 'LIMS::DB::RequestPhoneLog',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_print_log => {
            class      => 'LIMS::DB::RequestPrintLog',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_report_history => {
            class      => 'LIMS::DB::RequestReportHistory',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_view_log => {
            class      => 'LIMS::DB::RequestViewLog',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        user_message_sender => {
            class      => 'LIMS::DB::UserMessage',
            column_map => { id => 'sender_id' },
            type       => 'one to many',
        },
        
        user_message_recipient => {
            class      => 'LIMS::DB::UserMessage',
            column_map => { id => 'recipient_id' },
            type       => 'one to many',
        },
        
        user_permission => {
            class      => 'LIMS::DB::UserPermission',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },
    ],
);

# or to see what it should be:
#__PACKAGE__->meta->table('trials');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 2, braces => 'bsd');

__PACKAGE__->meta->make_manager_class('users');

1;
