package LIMS::DB::Outreach::Diagnosis;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',
    
    table   => 'diagnoses',

    columns => [
        diagnosis_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'diagnosis_id' ],

    foreign_keys => [
        diagnosis => {
            class       => 'LIMS::DB::Diagnosis',
            key_columns => { diagnosis_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('diagnoses');

1;